/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.markup;

import java.util.Locale;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.block.EclipseErrorDetailsBlock;
import org.eclipse.mylyn.wikitext.core.parser.markup.block.JavaStackTraceBlock;

public class ConfigurationBuilder {
    private final MarkupLanguageConfiguration configuration = new MarkupLanguageConfiguration();

    public static ConfigurationBuilder create() {
        return new ConfigurationBuilder();
    }

    public ConfigurationBuilder repositorySettings() {
        ConfigurationBuilder builder = ConfigurationBuilder.create();
        builder.disableUnwrappedParagraphs().escapingHtmlAndXml().newlinesMustCauseLineBreak().optimizeForRepositoryUsage().block(new EclipseErrorDetailsBlock()).block(new JavaStackTraceBlock());
        return builder;
    }

    public MarkupLanguageConfiguration configuration() {
        return this.configuration.clone();
    }

    public ConfigurationBuilder escapingHtmlAndXml() {
        this.configuration.setEscapingHtmlAndXml(true);
        return this;
    }

    public ConfigurationBuilder newlinesMustCauseLineBreak() {
        this.configuration.setNewlinesMustCauseLineBreak(true);
        return this;
    }

    public ConfigurationBuilder optimizeForRepositoryUsage() {
        this.configuration.setOptimizeForRepositoryUsage(true);
        return this;
    }

    public ConfigurationBuilder disableWikiWordLinking() {
        this.configuration.setWikiWordLinking(false);
        return this;
    }

    public ConfigurationBuilder locale(Locale locale) {
        this.configuration.setLocale(locale);
        return this;
    }

    public ConfigurationBuilder disableUnwrappedParagraphs() {
        this.configuration.setEnableUnwrappedParagraphs(false);
        return this;
    }

    public ConfigurationBuilder phraseModifier(PatternBasedElement phraseModifier) {
        this.configuration.getPhraseModifiers().add(phraseModifier);
        return this;
    }

    public ConfigurationBuilder block(Block block) {
        this.configuration.getBlocks().add(block);
        return this;
    }

    public ConfigurationBuilder token(PatternBasedElement tokenSyntax) {
        this.configuration.getTokens().add(tokenSyntax);
        return this;
    }
}

