/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.callgraph;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.Messages;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;

abstract class AbstractCalledFunction
implements ICalledFunction {
    static final Comparator<ISegment> COMPARATOR;
    private static final long serialVersionUID = 7992199223906717340L;
    protected final long fStart;
    protected final long fEnd;
    protected final int fDepth;
    private final List<ICalledFunction> fChildren = new ArrayList<ICalledFunction>();
    private final @Nullable ICalledFunction fParent;
    protected long fSelfTime = 0L;
    private final int fProcessId;

    static {
        Ordering comp = Ordering.from((Comparator)SegmentComparators.INTERVAL_START_COMPARATOR).compound(SegmentComparators.INTERVAL_END_COMPARATOR);
        COMPARATOR = (Comparator)NonNullUtils.checkNotNull((Object)comp);
    }

    public AbstractCalledFunction(long start, long end, int depth, int processId, @Nullable ICalledFunction parent) {
        if (start > end) {
            throw new IllegalArgumentException(String.valueOf(Messages.TimeError) + "[" + start + "," + end + "]");
        }
        this.fStart = start;
        this.fEnd = end;
        this.fDepth = depth;
        this.fParent = parent;
        this.fSelfTime = this.fEnd - this.fStart;
        this.fProcessId = processId;
    }

    public long getStart() {
        return this.fStart;
    }

    public long getEnd() {
        return this.fEnd;
    }

    @Override
    public List<ICalledFunction> getChildren() {
        return this.fChildren;
    }

    @Override
    public @Nullable ICalledFunction getParent() {
        return this.fParent;
    }

    public void addChild(ICalledFunction child) {
        if (child.getParent() != this) {
            throw new IllegalArgumentException("Child parent not the same as child being added to.");
        }
        this.fChildren.add(child);
        this.substractChildDuration(child.getEnd() - child.getStart());
    }

    private void substractChildDuration(long childDuration) {
        this.fSelfTime -= childDuration;
    }

    @Override
    public long getSelfTime() {
        return this.fSelfTime;
    }

    @Override
    public int getDepth() {
        return this.fDepth;
    }

    @Override
    public int getProcessId() {
        return this.fProcessId;
    }

    public int compareTo(@Nullable ISegment o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        return COMPARATOR.compare(this, o);
    }

    public String toString() {
        return new String("[" + String.valueOf(this.fStart) + ", " + String.valueOf(this.fEnd) + "]");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fDepth;
        result = 31 * result + (int)(this.fEnd ^ this.fEnd >>> 32);
        ICalledFunction parent = this.fParent;
        result = 31 * result + (parent == null ? 0 : parent.hashCode());
        result = 31 * result + (int)(this.fSelfTime ^ this.fSelfTime >>> 32);
        result = 31 * result + (int)(this.fStart ^ this.fStart >>> 32);
        result = 31 * result + this.getSymbol().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCalledFunction other = (AbstractCalledFunction)obj;
        if (this.fDepth != other.fDepth) {
            return false;
        }
        if (this.fEnd != other.fEnd) {
            return false;
        }
        if (this.fParent == null ? other.fParent != null : !Objects.equals(this.fParent, other.fParent)) {
            return false;
        }
        if (this.fSelfTime != other.fSelfTime) {
            return false;
        }
        if (this.fStart != other.fStart) {
            return false;
        }
        return Objects.equals(this.getSymbol(), other.getSymbol());
    }
}

