/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.asciidoc.core.block;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.asciidoc.core.block.AsciiDocBlock;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

public class CodeBlock
extends AsciiDocBlock {
    String title;

    public CodeBlock() {
        super(Pattern.compile("^----.*"));
    }

    @Override
    protected void processBlockStart() {
        this.title = this.getAsciiDocState().getLastTitle();
        Attributes attributes = new Attributes();
        attributes.setCssClass("listingblock");
        this.builder.beginBlock(DocumentBuilder.BlockType.DIV, attributes);
        if (this.title != null) {
            attributes = new Attributes();
            attributes.setCssClass("title");
            this.builder.beginBlock(DocumentBuilder.BlockType.DIV, attributes);
            this.builder.characters(this.title);
            this.builder.endBlock();
        }
        attributes = new Attributes();
        attributes.setCssClass("content");
        this.builder.beginBlock(DocumentBuilder.BlockType.DIV, attributes);
        ArrayList<String> postitonalParams = new ArrayList<String>();
        postitonalParams.add("type");
        postitonalParams.add("language");
        Map<String, String> properties = this.getAsciiDocState().getLastProperties(postitonalParams);
        attributes = new Attributes();
        attributes.setCssClass("nowrap");
        if (properties.containsKey("language")) {
            attributes.appendCssClass("source-" + properties.get("language"));
        }
        this.builder.beginBlock(DocumentBuilder.BlockType.CODE, attributes);
    }

    @Override
    protected void processBlockContent(String line) {
        this.builder.characters(line);
        this.builder.lineBreak();
    }

    @Override
    protected void processBlockEnd() {
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endBlock();
    }
}

