/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.PatternRule;

public class AutomakeMacroReferenceRule
extends PatternRule {
    int nOfBrackets;
    int fBracket;

    public AutomakeMacroReferenceRule(IToken token, String startSeq, String endSeq) {
        super(startSeq, endSeq, token, '\u0000', true);
        this.fBracket = endSeq.length() > 0 && endSeq.charAt(0) == '}' ? 123 : 40;
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        this.nOfBrackets = 1;
        return super.doEvaluate(scanner, resume);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        while ((c = scanner.read()) != -1) {
            if (this.fBracket == c) {
                ++this.nOfBrackets;
            }
            if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (!this.sequenceDetected(scanner, this.fEndSequence, true) || --this.nOfBrackets != 0) continue;
                return true;
            }
            if (!this.fBreaksOnEOL) continue;
            int i = 0;
            while (i < delimiters.length) {
                if (c == delimiters[i][0] && this.sequenceDetected(scanner, delimiters[i], false)) {
                    return true;
                }
                ++i;
            }
        }
        scanner.unread();
        return false;
    }
}

