/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.processors.CachingStringProcessor;
import org.eclipse.epp.internal.logging.aeri.ide.processors.ConfigurationInfo;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;

public abstract class PlatformDetailsSectionProcessor
extends CachingStringProcessor
implements IReportProcessor {
    public String sectionTitle;

    public PlatformDetailsSectionProcessor(IProcessorDescriptor descriptor, String sectionTitle) {
        super(descriptor);
        this.sectionTitle = sectionTitle;
    }

    @Override
    public boolean canContribute(IStatus status) {
        return !StringUtils.isEmpty((CharSequence)ConfigurationInfo.getConfiguration("Platform Details"));
    }

    public final boolean wantsToContribute(IStatus status, IEclipseContext context) {
        return false;
    }

    @Override
    @VisibleForTesting
    protected String doAnalyze() {
        String configuration = ConfigurationInfo.getConfiguration("Platform Details");
        int sectionStart = configuration.indexOf(this.sectionTitle);
        if (sectionStart == -1) {
            return "";
        }
        int sectionEnd = configuration.indexOf("*** ", (sectionStart += this.sectionTitle.length()) + 1) - 1;
        if (sectionEnd < 0 && (sectionEnd = configuration.indexOf(String.valueOf(System.lineSeparator()) + System.lineSeparator(), sectionStart + 1) - 1) < 0) {
            sectionEnd = configuration.length();
        }
        return configuration.substring(sectionStart, sectionEnd);
    }
}

