/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.commons.workbench.AdaptiveRefreshPolicy;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListInterestFilter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListInterestSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskScheduleContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class FocusTaskListAction
implements AdaptiveRefreshPolicy.IFilteredTreeListener,
IViewActionDelegate,
IActionDelegate2 {
    private Set<AbstractTaskListFilter> previousFilters = new HashSet<AbstractTaskListFilter>();
    private ViewerSorter previousSorter;
    private final TaskListInterestFilter taskListInterestFilter = new TaskListInterestFilter();
    private final TaskListInterestSorter taskListInterestSorter = new TaskListInterestSorter();
    private TaskListView taskListView;
    private IAction action;

    public void filterTextChanged(String text) {
        if (this.taskListView.isFocusedMode() && (text == null || "".equals(text.trim()))) {
            this.taskListView.getViewer().expandAll();
        }
    }

    public void init(IAction action) {
        this.action = action;
        this.initAction();
    }

    public void init(IViewPart view) {
        if (view instanceof TaskListView) {
            this.taskListView = (TaskListView)view;
            this.taskListView.getFilteredTree().getRefreshPolicy().addListener((AdaptiveRefreshPolicy.IFilteredTreeListener)this);
            this.taskListView.getFilteredTree().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    FocusTaskListAction.this.taskListView.getFilteredTree().getRefreshPolicy().removeListener((AdaptiveRefreshPolicy.IFilteredTreeListener)FocusTaskListAction.this);
                }
            });
            if (TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.task.list.focused")) {
                this.installInterestFilter();
            }
            this.initAction();
            this.showProgressBar(this.taskListView.isFocusedMode());
        }
    }

    private void initAction() {
        if (this.action != null && this.taskListView != null) {
            this.action.setChecked(this.taskListView.isFocusedMode());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void showProgressBar(boolean visible) {
        this.taskListView.getFilteredTree().setShowProgress(visible);
    }

    protected void installInterestFilter() {
        TasksUiInternal.preservingSelection(this.taskListView.getViewer(), new Runnable(){

            @Override
            public void run() {
                try {
                    FocusTaskListAction.this.taskListView.getFilteredTree().setRedraw(false);
                    FocusTaskListAction.this.taskListView.setFocusedMode(true);
                    FocusTaskListAction.this.previousSorter = FocusTaskListAction.this.taskListView.getViewer().getSorter();
                    FocusTaskListAction.this.previousFilters = FocusTaskListAction.this.taskListView.clearFilters();
                    if (!FocusTaskListAction.this.taskListView.getFilters().contains(FocusTaskListAction.this.taskListInterestFilter)) {
                        FocusTaskListAction.this.taskListView.addFilter(FocusTaskListAction.this.taskListInterestFilter);
                    }
                    FocusTaskListAction.this.taskListView.getViewer().setSorter((ViewerSorter)FocusTaskListAction.this.taskListInterestSorter);
                    FocusTaskListAction.this.taskListView.getViewer().expandAll();
                    FocusTaskListAction.this.showProgressBar(true);
                }
                finally {
                    FocusTaskListAction.this.taskListView.getFilteredTree().setRedraw(true);
                }
            }
        });
    }

    protected void uninstallInterestFilter() {
        TasksUiInternal.preservingSelection(this.taskListView.getViewer(), new Runnable(){

            @Override
            public void run() {
                try {
                    FocusTaskListAction.this.taskListView.getViewer().getControl().setRedraw(false);
                    FocusTaskListAction.this.taskListView.setFocusedMode(false);
                    for (AbstractTaskListFilter filter : FocusTaskListAction.this.previousFilters) {
                        FocusTaskListAction.this.taskListView.addFilter(filter);
                    }
                    FocusTaskListAction.this.taskListView.removeFilter(FocusTaskListAction.this.taskListInterestFilter);
                    Text textControl = FocusTaskListAction.this.taskListView.getFilteredTree().getFilterControl();
                    if (textControl != null && textControl.getText().length() > 0) {
                        FocusTaskListAction.this.taskListView.getViewer().expandAll();
                    } else {
                        TreeItem item;
                        FocusTaskListAction.this.taskListView.getViewer().collapseAll();
                        if (FocusTaskListAction.this.taskListView.getViewer().getContentProvider() instanceof TaskScheduleContentProvider && FocusTaskListAction.this.taskListView.getViewer().getTree().getItemCount() > 0 && (item = FocusTaskListAction.this.taskListView.getViewer().getTree().getItem(0)).getData() != null) {
                            FocusTaskListAction.this.taskListView.getViewer().expandToLevel(item.getData(), 1);
                        }
                    }
                    FocusTaskListAction.this.taskListView.getViewer().setSorter(FocusTaskListAction.this.previousSorter);
                    FocusTaskListAction.this.showProgressBar(false);
                }
                finally {
                    FocusTaskListAction.this.taskListView.getViewer().getControl().setRedraw(true);
                }
            }
        });
    }

    public void run() {
        if (this.taskListView == null) {
            return;
        }
        if (!this.taskListView.isFocusedMode()) {
            TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.task.list.focused", true);
            this.installInterestFilter();
        } else {
            TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.task.list.focused", false);
            this.uninstallInterestFilter();
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void runWithEvent(IAction action, Event event) {
        this.run();
    }

    public void dispose() {
    }
}

