/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.piecharts.model.TmfPieChartStatisticsModel;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.TmfStatisticsViewer;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsTree;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsTreeManager;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.statistics.ITmfStatistics;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsModule;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

class StatisticsUpdateJob
extends Job {
    private final ITmfTrace fJobTrace;
    private final boolean fIsGlobal;
    private final TmfStatisticsModule fStatsMod;
    private final TmfStatisticsViewer fViewer;
    private static final long LIVE_UPDATE_DELAY = 1000L;
    private TmfTimeRange fTimerange;

    public StatisticsUpdateJob(String name, ITmfTrace trace, boolean isGlobal, TmfTimeRange timerange, TmfStatisticsModule statsMod, TmfStatisticsViewer viewer) {
        super(name);
        this.fJobTrace = trace;
        this.fIsGlobal = isGlobal;
        this.fTimerange = timerange;
        this.fStatsMod = statsMod;
        this.fViewer = viewer;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!this.fStatsMod.waitForInitialization()) {
            return Status.CANCEL_STATUS;
        }
        ITmfStatistics stats = this.fStatsMod.getStatistics();
        if (stats == null) {
            throw new IllegalStateException();
        }
        ITmfStateSystem ss = this.fStatsMod.getStateSystem("org.eclipse.linuxtools.tmf.statistics.types");
        if (ss == null) {
            throw new IllegalStateException();
        }
        long start = 0L;
        long end = 0L;
        boolean finished = false;
        do {
            if (monitor.isCanceled()) {
                this.fViewer.removeFromJobs(this.fIsGlobal, this.fJobTrace);
                return Status.CANCEL_STATUS;
            }
            finished = ss.waitUntilBuilt(1000L);
            TmfTimeRange localtimeRange = this.fTimerange;
            start = localtimeRange.getStartTime().toNanos();
            end = localtimeRange.getEndTime().toNanos();
            Map map = stats.getEventTypesInRange(start, end);
            this.updateStats(map);
        } while (!finished);
        Map map = stats.getEventTypesInRange(start, end);
        this.updateStats(map);
        this.fViewer.refreshPieCharts(this.fIsGlobal, !this.fIsGlobal);
        this.fViewer.removeFromJobs(this.fIsGlobal, this.fJobTrace);
        return Status.OK_STATUS;
    }

    private void updateStats(Map<String, Long> eventsPerType) {
        TmfStatisticsTree statsData = TmfStatisticsTreeManager.getStatTree(this.fViewer.getTreeID());
        if (statsData == null) {
            return;
        }
        Map<String, Long> map = eventsPerType;
        String name = this.fJobTrace.getName();
        if (map.isEmpty() && !this.fIsGlobal) {
            TmfStatisticsTreeNode eventTypeNode = statsData.getNode(name, TmfStatisticsTree.HEADER_EVENT_TYPES);
            if (eventTypeNode != null) {
                eventTypeNode.resetTimeRangeValue();
            }
        } else {
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                statsData.setTypeCount(name, entry.getKey(), this.fIsGlobal, entry.getValue());
            }
        }
        long globalTotal = 0L;
        for (long val : map.values()) {
            globalTotal += val;
        }
        statsData.setTotal(name, this.fIsGlobal, globalTotal);
        TmfPieChartStatisticsModel model = this.fViewer.getPieChartModel();
        if (model != null) {
            model.setPieChartTypeCount(this.fIsGlobal, this.fJobTrace, eventsPerType);
        }
        this.fViewer.modelComplete(this.fIsGlobal);
    }
}

