/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.internal.ui.dialogs.ResizableStatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.preferences.HeaderSubstitutionRule;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class HeaderSubstitutionEditDialog
extends ResizableStatusDialog {
    private final StringDialogField fSourceField;
    private final StringDialogField fTargetField;
    private final SelectionButtonDialogField fRequiredSubstitutionCheckBox;

    public HeaderSubstitutionEditDialog(Shell shell, HeaderSubstitutionRule rule) {
        super(shell);
        if (rule == null || rule.getSource().isEmpty()) {
            this.setTitle(PreferencesMessages.HeaderSubstitutionEditDialog_new_title);
        } else {
            this.setTitle(PreferencesMessages.HeaderSubstitutionEditDialog_edit_title);
        }
        IDialogFieldListener listener = new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                HeaderSubstitutionEditDialog.this.validate();
            }
        };
        this.fSourceField = new StringDialogField();
        this.fSourceField.setLabelText(PreferencesMessages.HeaderSubstitutionEditDialog_source);
        this.fSourceField.setDialogFieldListener(listener);
        this.fTargetField = new StringDialogField();
        this.fTargetField.setLabelText(PreferencesMessages.HeaderSubstitutionEditDialog_target);
        this.fTargetField.setDialogFieldListener(listener);
        this.fRequiredSubstitutionCheckBox = new SelectionButtonDialogField(32);
        this.fRequiredSubstitutionCheckBox.setLabelText(PreferencesMessages.HeaderSubstitutionEditDialog_required_substitution);
        if (rule != null) {
            this.fSourceField.setText(rule.getSource());
            this.fTargetField.setText(rule.getTarget());
            this.fRequiredSubstitutionCheckBox.setSelection(rule.isUnconditionalSubstitution());
        }
        this.validate();
    }

    public HeaderSubstitutionRule getResult() {
        return new HeaderSubstitutionRule(this.fSourceField.getText().trim(), this.fTargetField.getText().trim(), this.fRequiredSubstitutionCheckBox.isSelected());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.cdt.ui.header_substitution_edit_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        PixelConverter conv = new PixelConverter((Control)composite);
        Composite inner = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        int len = PreferencesMessages.HeaderSubstitutionEditDialog_enter_target.length() + 5;
        gridData.widthHint = conv.convertWidthInCharsToPixels(len);
        inner.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.fSourceField.doFillIntoGrid(inner, 2);
        this.fTargetField.doFillIntoGrid(inner, 2);
        this.fRequiredSubstitutionCheckBox.doFillIntoGrid(composite, 2);
        HeaderSubstitutionEditDialog.applyDialogFont((Control)composite);
        this.validate();
        return composite;
    }

    private void validate() {
        IStatus status = StatusInfo.OK_STATUS;
        String source = this.fSourceField.getText().trim();
        String target = this.fTargetField.getText().trim();
        if (source.isEmpty()) {
            status = new StatusInfo(1, PreferencesMessages.HeaderSubstitutionEditDialog_enter_source);
        } else if (!this.isValidHeader(source)) {
            status = new StatusInfo(2, PreferencesMessages.HeaderSubstitutionEditDialog_invalid_source);
        } else if (target.isEmpty()) {
            status = new StatusInfo(1, PreferencesMessages.HeaderSubstitutionEditDialog_enter_target);
        } else if (!this.isValidHeader(target)) {
            status = new StatusInfo(2, PreferencesMessages.HeaderSubstitutionEditDialog_invalid_target);
        } else if (target.equals(source)) {
            status = new StatusInfo(2, PreferencesMessages.HeaderSubstitutionEditDialog_error_replacement_by_itself);
        }
        this.updateStatus(status);
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState((IStatus)(status.isOK() ? status : new StatusInfo(4, null)));
    }

    private boolean isValidHeader(String header) {
        if (header.isEmpty()) {
            return false;
        }
        if (header.startsWith("<") != header.endsWith(">")) {
            return false;
        }
        return !header.startsWith("<") || header.length() >= 3;
    }
}

