/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.AssemblyLanguage;
import org.eclipse.cdt.core.model.IAsmLanguage;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.ui.editor.asm.AsmCodeScanner;
import org.eclipse.cdt.internal.ui.editor.asm.AsmPreprocessorScanner;
import org.eclipse.cdt.internal.ui.editor.asm.AsmReconcilingStrategy;
import org.eclipse.cdt.internal.ui.text.CCommentScanner;
import org.eclipse.cdt.internal.ui.text.PartitionDamager;
import org.eclipse.cdt.internal.ui.text.SingleTokenCScanner;
import org.eclipse.cdt.internal.ui.text.TokenStore;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.ILanguageUI;
import org.eclipse.cdt.ui.text.AbstractCScanner;
import org.eclipse.cdt.ui.text.IColorManager;
import org.eclipse.cdt.ui.text.ITokenStore;
import org.eclipse.cdt.ui.text.ITokenStoreFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class AsmSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private ITextEditor fTextEditor;
    private AbstractCScanner fCodeScanner;
    private AbstractCScanner fMultilineCommentScanner;
    private AbstractCScanner fSinglelineCommentScanner;
    private AbstractCScanner fStringScanner;
    private AbstractCScanner fPreprocessorScanner;
    private IColorManager fColorManager;
    private String fDocumentPartitioning;

    public AsmSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(preferenceStore);
        this.fColorManager = colorManager;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
        this.initializeScanners();
    }

    private void initializeScanners() {
        this.fMultilineCommentScanner = new CCommentScanner(this.getTokenStoreFactory(), "c_multi_line_comment");
        this.fSinglelineCommentScanner = new CCommentScanner(this.getTokenStoreFactory(), "c_single_line_comment");
        this.fStringScanner = new SingleTokenCScanner(this.getTokenStoreFactory(), "c_string");
    }

    public RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    public RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    public RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    public RuleBasedScanner getPreprocessorScanner(ILanguage language) {
        if (this.fPreprocessorScanner != null) {
            return this.fPreprocessorScanner;
        }
        AsmPreprocessorScanner scanner = null;
        if (language instanceof IAsmLanguage) {
            scanner = new AsmPreprocessorScanner(this.getTokenStoreFactory(), (IAsmLanguage)language);
        }
        if (scanner == null) {
            scanner = new AsmPreprocessorScanner(this.getTokenStoreFactory(), (IAsmLanguage)AssemblyLanguage.getDefault());
        }
        this.fPreprocessorScanner = scanner;
        return this.fPreprocessorScanner;
    }

    public RuleBasedScanner getCodeScanner(ILanguage language) {
        ILanguageUI languageUI;
        if (this.fCodeScanner != null) {
            return this.fCodeScanner;
        }
        AsmCodeScanner scanner = null;
        if (language instanceof IAsmLanguage) {
            IAsmLanguage asmLang = (IAsmLanguage)language;
            scanner = new AsmCodeScanner(this.getTokenStoreFactory(), asmLang);
        } else if (language != null && (languageUI = (ILanguageUI)language.getAdapter(ILanguageUI.class)) != null) {
            scanner = languageUI.getCodeScanner();
        }
        if (scanner == null) {
            scanner = new AsmCodeScanner(this.getTokenStoreFactory(), (IAsmLanguage)AssemblyLanguage.getDefault());
        }
        if (scanner instanceof AbstractCScanner) {
            this.fCodeScanner = scanner;
        }
        return scanner;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        ILanguage language = this.getLanguage();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner(language));
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__c_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_multiline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__c_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_singleline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__c_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__c_character");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_character");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getPreprocessorScanner(language));
        reconciler.setDamager((IPresentationDamager)new PartitionDamager(), "__c_preprocessor");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_preprocessor");
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        return reconciler;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__c_multiline_comment", "__c_singleline_comment", "__c_string", "__c_character", "__c_preprocessor"};
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fTextEditor != null) {
            MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)new AsmReconcilingStrategy(this.fTextEditor), false);
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return super.getReconciler(sourceViewer);
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        if (this.fMultilineCommentScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event)) {
            return true;
        }
        if (this.fCodeScanner != null && this.fCodeScanner.affectsBehavior(event)) {
            return true;
        }
        return this.fPreprocessorScanner != null && this.fPreprocessorScanner.affectsBehavior(event);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fCodeScanner != null && this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fPreprocessorScanner != null && this.fPreprocessorScanner.affectsBehavior(event)) {
            this.fPreprocessorScanner.adaptToPreferenceChange(event);
        }
    }

    public IColorManager getColorManager() {
        return this.fColorManager;
    }

    public ILanguage getLanguage() {
        if (this.fTextEditor == null) {
            return AssemblyLanguage.getDefault();
        }
        IWorkingCopy element = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fTextEditor.getEditorInput());
        if (element instanceof ITranslationUnit) {
            try {
                return ((ITranslationUnit)element).getLanguage();
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        } else {
            IContentType contentType = null;
            IEditorInput input = this.fTextEditor.getEditorInput();
            IFile file = ResourceUtil.getFile((IEditorInput)input);
            if (file != null) {
                contentType = CCorePlugin.getContentType((IProject)file.getProject(), (String)file.getName());
            } else if (input instanceof IPathEditorInput) {
                IPath path = ((IPathEditorInput)input).getPath();
                contentType = CCorePlugin.getContentType((String)path.lastSegment());
            } else {
                ILocationProvider locationProvider = (ILocationProvider)input.getAdapter(ILocationProvider.class);
                if (locationProvider != null) {
                    IPath path = locationProvider.getPath((Object)input);
                    contentType = CCorePlugin.getContentType((String)path.lastSegment());
                }
            }
            if (contentType != null) {
                return LanguageManager.getInstance().getLanguage(contentType);
            }
        }
        return AssemblyLanguage.getDefault();
    }

    public void resetScanners() {
        this.fCodeScanner = null;
        this.fPreprocessorScanner = null;
    }

    private ITokenStoreFactory getTokenStoreFactory() {
        return new ITokenStoreFactory(){

            @Override
            public ITokenStore createTokenStore(String[] propertyColorNames) {
                return new TokenStore(AsmSourceViewerConfiguration.this.getColorManager(), AsmSourceViewerConfiguration.this.fPreferenceStore, propertyColorNames);
            }
        };
    }
}

