/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.ServiceLocator;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.CacheCredentialsAuthenticationStrategy;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.CacheCredentialsInterceptor;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.DefaultCredentialsProviderInterceptor;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.ExecutorClientWrapper;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientProxyUtil;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpContextInterceptor;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.RequestTemplate;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.SynchronizedCredentialsProviderInterceptor;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.SystemCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.util.ProxyHelper;
import org.eclipse.epp.mpc.core.service.ITransport;
import org.eclipse.epp.mpc.core.service.ServiceUnavailableException;
import org.eclipse.userstorage.internal.StorageProperties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientTransport
implements ITransport {
    public static final String USER_AGENT;
    public static final String USER_AGENT_PROPERTY;
    private static final HttpClientConnectionManager CONNMGR;
    private final HttpClient client = HttpClientTransport.createClient(CONNMGR, new DefaultCredentialsProviderInterceptor((CredentialsProvider)new SystemCredentialsProvider()), new CacheCredentialsInterceptor(), SynchronizedCredentialsProviderInterceptor.INSTANCE);
    private final CookieStore cookieStore = new BasicCookieStore();
    private final Executor executor = Executor.newInstance((HttpClient)this.client).cookieStore(this.cookieStore);

    static {
        USER_AGENT_PROPERTY = String.valueOf(HttpClientTransport.class.getPackage().getName()) + ".userAgent";
        USER_AGENT = HttpClientTransport.initUserAgent();
        CONNMGR = HttpClientTransport.initConnectionManager();
    }

    private static HttpClientConnectionManager initConnectionManager() {
        HttpClientConnectionManager connectionManager;
        block14: {
            boolean accessible = false;
            connectionManager = null;
            Field connectionManagerField = null;
            try {
                try {
                    connectionManagerField = Executor.class.getDeclaredField("CONNMGR");
                    accessible = connectionManagerField.isAccessible();
                    connectionManagerField.setAccessible(true);
                    connectionManager = (HttpClientConnectionManager)connectionManagerField.get(null);
                }
                catch (Throwable throwable) {
                    if (connectionManagerField != null && !accessible) {
                        try {
                            connectionManagerField.setAccessible(false);
                        }
                        catch (SecurityException securityException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (connectionManagerField != null && !accessible) {
                    try {
                        connectionManagerField.setAccessible(false);
                    }
                    catch (SecurityException securityException) {}
                }
                throw throwable;
            }
            if (connectionManagerField != null && !accessible) {
                try {
                    connectionManagerField.setAccessible(false);
                }
                catch (SecurityException securityException) {}
            }
        }
        return connectionManager;
    }

    private static String initUserAgent() {
        Bundle mpcCoreBundle = FrameworkUtil.getBundle(HttpClientTransport.class);
        BundleContext context = mpcCoreBundle.getBundleContext();
        String version = HttpClientTransport.getAgentVersion(mpcCoreBundle);
        String java = HttpClientTransport.getAgentJava(context);
        String os = HttpClientTransport.getAgentOS(context);
        String language = HttpClientTransport.getProperty(context, "osgi.nl", "unknownLanguage");
        String agentDetail = HttpClientTransport.getAgentDetail(context);
        String userAgent = MessageFormat.format("mpc/{0} (Java {1}; {2}; {3}) {4}", version, java, os, language, agentDetail);
        return userAgent;
    }

    private static String getAgentVersion(Bundle bundle) {
        Version mpcCoreVersion = bundle.getVersion();
        String version = MessageFormat.format("{0}.{1}.{2}", mpcCoreVersion.getMajor(), mpcCoreVersion.getMinor(), mpcCoreVersion.getMicro());
        return version;
    }

    private static String getAgentJava(BundleContext context) {
        String javaSpec = HttpClientTransport.getProperty(context, "java.runtime.version", "unknownJava");
        String javaVendor = HttpClientTransport.getProperty(context, "java.vendor", "unknownJavaVendor");
        String java = MessageFormat.format("{0} {1}", javaSpec, javaVendor);
        return java;
    }

    private static String getAgentOS(BundleContext context) {
        String osName = HttpClientTransport.getProperty(context, "org.osgi.framework.os.name", "unknownOS");
        String osVersion = HttpClientTransport.getProperty(context, "org.osgi.framework.os.version", "unknownOSVersion");
        String osArch = HttpClientTransport.getProperty(context, "org.osgi.framework.processor", "unknownArch");
        String os = MessageFormat.format("{0} {1} {2}", osName, osVersion, osArch);
        return os;
    }

    private static String getAgentDetail(BundleContext context) {
        String agentDetail = HttpClientTransport.getProperty(context, USER_AGENT_PROPERTY, null);
        if (agentDetail == null) {
            String productId = HttpClientTransport.getProperty(context, "eclipse.product", null);
            String productVersion = HttpClientTransport.getProperty(context, "eclipse.buildId", null);
            String appId = HttpClientTransport.getProperty(context, "eclipse.application", null);
            if (productId == null || productVersion == null) {
                Map<String, String> defaultRequestMetaParameters = ServiceLocator.computeDefaultRequestMetaParameters();
                productId = HttpClientTransport.getProperty(defaultRequestMetaParameters, (Object)"product", "unknownProduct");
                productVersion = HttpClientTransport.getProperty(defaultRequestMetaParameters, (Object)"product.version", "unknownBuildId");
            }
            if (appId == null) {
                IProduct product = Platform.getProduct();
                if (product != null) {
                    appId = product.getApplication();
                }
                if (appId == null) {
                    appId = "unknownApp";
                }
            }
            agentDetail = MessageFormat.format("{0}/{1} ({2})", productId, productVersion, appId);
        }
        return agentDetail;
    }

    private static String getProperty(BundleContext context, String key, String defaultValue) {
        String value = context.getProperty(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static String getProperty(Map<?, String> properties, Object key, String defaultValue) {
        String value = properties.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static HttpClient createClient(HttpClientConnectionManager connectionManager, HttpContextInterceptor ... interceptors) {
        HttpClientBuilder builder = connectionManager == null ? HttpClientBuilder.create().setMaxConnPerRoute(100).setMaxConnTotal(200) : HttpClientBuilder.create().setConnectionManager(connectionManager);
        builder.setTargetAuthenticationStrategy((AuthenticationStrategy)new CacheCredentialsAuthenticationStrategy.Target((AuthenticationStrategy)TargetAuthenticationStrategy.INSTANCE));
        builder.setProxyAuthenticationStrategy((AuthenticationStrategy)new CacheCredentialsAuthenticationStrategy.Proxy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE));
        builder.setUserAgent(USER_AGENT);
        return new ExecutorClientWrapper((HttpClient)builder.build(), interceptors);
    }

    protected Response execute(Request request, URI uri) throws ClientProtocolException, IOException {
        ProxyHelper.installAuthenticator();
        return HttpClientProxyUtil.proxyAuthentication(this.executor, uri).execute(request);
    }

    protected Request configureRequest(Request request, URI uri) {
        return request.viaProxy(HttpClientProxyUtil.getProxyHost(uri)).staleConnectionCheck(true).connectTimeout(StorageProperties.getProperty((String)"org.eclipse.userstorage.connectTimeout", (int)120000)).socketTimeout(StorageProperties.getProperty((String)"org.eclipse.userstorage.socketTimeout", (int)120000));
    }

    @Override
    public InputStream stream(URI location, IProgressMonitor monitor) throws FileNotFoundException, ServiceUnavailableException, CoreException {
        try {
            return this.createStreamingRequest().execute(location);
        }
        catch (HttpResponseException e) {
            int statusCode = e.getStatusCode();
            switch (statusCode) {
                case 404: {
                    FileNotFoundException fnfe = new FileNotFoundException(e.getMessage());
                    fnfe.initCause(e);
                    throw fnfe;
                }
                case 503: {
                    throw new ServiceUnavailableException((IStatus)new Status(4, "org.eclipse.epp.mpc.core", e.getMessage(), (Throwable)e));
                }
            }
            throw new CoreException(MarketplaceClientCore.computeStatus(e, null));
        }
        catch (IOException e) {
            throw new CoreException(MarketplaceClientCore.computeStatus(e, null));
        }
    }

    protected RequestTemplate<InputStream> createStreamingRequest() {
        return new RequestTemplate<InputStream>(this){

            @Override
            protected Request createRequest(URI uri) {
                return Request.Get((URI)uri);
            }

            @Override
            protected InputStream handleResponse(Response response) throws ClientProtocolException, IOException {
                HttpResponse returnResponse = response.returnResponse();
                HttpEntity entity = returnResponse.getEntity();
                StatusLine statusLine = returnResponse.getStatusLine();
                this.handleResponseStatus(statusLine.getStatusCode(), statusLine.getReasonPhrase(), entity);
                return (InputStream)this.handleResponseEntity(entity);
            }

            @Override
            protected InputStream handleResponseStream(InputStream content) throws IOException {
                return content;
            }

            @Override
            protected InputStream handleEmptyResponse() {
                return new ByteArrayInputStream(new byte[0]);
            }
        };
    }
}

