/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.latency;

import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.SegmentStoreStatistics;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.statistics.AbstractSegmentStoreStatisticsViewer;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternLatencyStatisticsAnalysis;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class PatternStatisticsViewer
extends AbstractSegmentStoreStatisticsViewer {
    private String fAnalysisId;
    private static final @NonNull String PATTERN_SEGMENTS_LEVEL = "Pattern Segments";

    public PatternStatisticsViewer(@NonNull Composite parent) {
        super(parent);
    }

    protected @Nullable TmfAbstractAnalysisModule createStatisticsAnalysiModule() {
        return new XmlPatternLatencyStatisticsAnalysis(this.fAnalysisId);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected ITmfTreeViewerEntry updateElements(long start, long end, boolean isSelection) {
        if (isSelection || start == end) {
            return null;
        }
        TmfAbstractAnalysisModule analysisModule = this.getStatisticsAnalysisModule();
        if (this.getTrace() == null || !(analysisModule instanceof XmlPatternLatencyStatisticsAnalysis)) {
            return null;
        }
        XmlPatternLatencyStatisticsAnalysis module = (XmlPatternLatencyStatisticsAnalysis)analysisModule;
        module.waitForCompletion();
        TmfTreeViewerEntry root = new TmfTreeViewerEntry("");
        SegmentStoreStatistics entry = module.getTotalStats();
        if (entry != null) {
            List entryList = root.getChildren();
            AbstractSegmentStoreStatisticsViewer.SegmentStoreStatisticsEntry child = new AbstractSegmentStoreStatisticsViewer.SegmentStoreStatisticsEntry((AbstractSegmentStoreStatisticsViewer)this, (String)NonNullUtils.checkNotNull((Object)"Total"), entry);
            entryList.add(child);
            AbstractSegmentStoreStatisticsViewer.HiddenTreeViewerEntry segments = new AbstractSegmentStoreStatisticsViewer.HiddenTreeViewerEntry((AbstractSegmentStoreStatisticsViewer)this, PATTERN_SEGMENTS_LEVEL);
            child.addChild((TmfTreeViewerEntry)segments);
            @NonNull @NonNull Map perTypeStats = module.getPerSegmentTypeStats();
            if (perTypeStats != null) {
                for (Map.Entry statsEntry : perTypeStats.entrySet()) {
                    segments.addChild((TmfTreeViewerEntry)new AbstractSegmentStoreStatisticsViewer.SegmentStoreStatisticsEntry((AbstractSegmentStoreStatisticsViewer)this, (String)statsEntry.getKey(), (SegmentStoreStatistics)statsEntry.getValue()));
                }
            }
        }
        return root;
    }

    public void updateViewer(String analysisId) {
        if (analysisId != null) {
            this.fAnalysisId = analysisId;
            this.initializeDataSource();
        }
    }
}

