/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.format;

import com.google.common.collect.BiMap;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public class LamiLabelFormat
extends Format {
    private static final long serialVersionUID = 4939553034329681316L;
    private static final String SWTCHART_EMPTY_LABEL = " ";
    private static final String UNKNOWN_REPRESENTATION = "?";
    private final BiMap<@Nullable String, Integer> fMap;

    public LamiLabelFormat(BiMap<@Nullable String, Integer> map) {
        this.fMap = map;
    }

    @Override
    public @Nullable StringBuffer format(@Nullable Object obj, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
        if (obj == null || toAppendTo == null) {
            return new StringBuffer(SWTCHART_EMPTY_LABEL);
        }
        Double doubleObj = (Double)obj;
        if (doubleObj % 1.0 != 0.0 || !this.fMap.containsValue((Object)doubleObj.intValue())) {
            return new StringBuffer(SWTCHART_EMPTY_LABEL);
        }
        for (Map.Entry entry : this.fMap.entrySet()) {
            if (Double.compare(((Integer)entry.getValue()).doubleValue(), doubleObj) != 0) continue;
            if (entry.getKey() == null) {
                return new StringBuffer(UNKNOWN_REPRESENTATION);
            }
            return toAppendTo.append((String)entry.getKey());
        }
        return new StringBuffer(SWTCHART_EMPTY_LABEL);
    }

    @Override
    public @Nullable Object parseObject(@Nullable String source, @Nullable ParsePosition pos) {
        return this.fMap.get((Object)source);
    }
}

