/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.latency.statistics;

import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.SegmentStoreStatistics;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.statistics.AbstractSegmentStoreStatisticsViewer;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.latency.statistics.SystemCallLatencyStatisticsAnalysisModule;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.latency.statistics.Messages;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class SystemCallLatencyStatisticsViewer
extends AbstractSegmentStoreStatisticsViewer {
    private static final String SYSCALL_LEVEL = (String)NonNullUtils.checkNotNull((Object)Messages.LatencyStatistics_SyscallLevelName);

    public SystemCallLatencyStatisticsViewer(Composite parent) {
        super(parent);
    }

    protected @Nullable TmfAbstractAnalysisModule createStatisticsAnalysiModule() {
        SystemCallLatencyStatisticsAnalysisModule module = new SystemCallLatencyStatisticsAnalysisModule();
        return module;
    }

    protected @Nullable ITmfTreeViewerEntry updateElements(long start, long end, boolean isSelection) {
        if (isSelection || start == end) {
            return null;
        }
        TmfAbstractAnalysisModule analysisModule = this.getStatisticsAnalysisModule();
        if (this.getTrace() == null || !(analysisModule instanceof SystemCallLatencyStatisticsAnalysisModule)) {
            return null;
        }
        SystemCallLatencyStatisticsAnalysisModule module = (SystemCallLatencyStatisticsAnalysisModule)analysisModule;
        module.waitForCompletion();
        TmfTreeViewerEntry root = new TmfTreeViewerEntry("");
        SegmentStoreStatistics entry = module.getTotalStats();
        if (entry != null) {
            List entryList = root.getChildren();
            AbstractSegmentStoreStatisticsViewer.SegmentStoreStatisticsEntry child = new AbstractSegmentStoreStatisticsViewer.SegmentStoreStatisticsEntry((AbstractSegmentStoreStatisticsViewer)this, (String)NonNullUtils.checkNotNull((Object)Messages.LatencyStatistics_TotalLabel), entry);
            entryList.add(child);
            AbstractSegmentStoreStatisticsViewer.HiddenTreeViewerEntry syscalls = new AbstractSegmentStoreStatisticsViewer.HiddenTreeViewerEntry((AbstractSegmentStoreStatisticsViewer)this, SYSCALL_LEVEL);
            child.addChild((TmfTreeViewerEntry)syscalls);
            Map perSyscallStats = module.getPerSegmentTypeStats();
            if (perSyscallStats != null) {
                for (Map.Entry statsEntry : perSyscallStats.entrySet()) {
                    syscalls.addChild((TmfTreeViewerEntry)new AbstractSegmentStoreStatisticsViewer.SegmentStoreStatisticsEntry((AbstractSegmentStoreStatisticsViewer)this, (String)statsEntry.getKey(), (SegmentStoreStatistics)statsEntry.getValue()));
                }
            }
        }
        return root;
    }
}

