/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers;

import com.google.common.collect.Iterators;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiChartModel;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.signals.LamiSelectionUpdateSignal;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.LamiGraphRange;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.LamiXYChartViewer;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.swtchart.IAxis;
import org.swtchart.IAxisTick;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;
import org.swtchart.Range;

public class LamiBarChartViewer
extends LamiXYChartViewer {
    private static final double LOGSCALE_EPSILON_FACTOR = 100.0;
    private final String[] fCategories;
    private final Map<ISeries, List<Mapping>> fIndexPerSeriesMapping;
    private final Map<LamiTableEntry, Mapping> fEntryToCategoriesMap;
    private LamiGraphRange fYInternalRange = new LamiGraphRange((BigDecimal)NonNullUtils.checkNotNull((Object)BigDecimal.ZERO), (BigDecimal)NonNullUtils.checkNotNull((Object)BigDecimal.ONE));
    private LamiGraphRange fYExternalRange;

    public LamiBarChartViewer(Composite parent, LamiResultTable resultTable, LamiChartModel chartModel) {
        super(parent, resultTable, chartModel);
        List<LamiTableEntryAspect> xAxisAspects = this.getXAxisAspects();
        List<LamiTableEntryAspect> yAxisAspects = this.getYAxisAspects();
        if (this.getChartModel().getChartType() != LamiChartModel.ChartType.BAR_CHART && xAxisAspects.size() != 1) {
            throw new IllegalArgumentException("Invalid configuration passed to a bar chart.");
        }
        this.getChart().getAxisSet().getXAxis(0).enableCategory(true);
        LamiTableEntryAspect xAxisAspect = xAxisAspects.get(0);
        List entries = this.getResultTable().getEntries();
        boolean logscale = chartModel.yAxisIsLog();
        this.fIndexPerSeriesMapping = new HashMap<ISeries, List<Mapping>>();
        this.fEntryToCategoriesMap = new HashMap<LamiTableEntry, Mapping>();
        Format formatter = null;
        if (xAxisAspect.isContinuous()) {
            formatter = LamiBarChartViewer.getContinuousAxisFormatter(xAxisAspects, entries, null, null);
        }
        ArrayList<@Nullable String> xCategories = new ArrayList<String>();
        int i = 0;
        while (i < entries.size()) {
            String string = xAxisAspect.resolveString((LamiTableEntry)entries.get(i));
            if (string == null) {
                this.fEntryToCategoriesMap.put((LamiTableEntry)entries.get(i), new Mapping(null, i));
            } else {
                this.fEntryToCategoriesMap.put((LamiTableEntry)entries.get(i), new Mapping(xCategories.size(), i));
                if (formatter != null) {
                    string = formatter.format(xAxisAspect.resolveNumber((LamiTableEntry)entries.get(i)));
                }
                xCategories.add(string);
            }
            ++i;
        }
        this.fCategories = xCategories.toArray(new String[0]);
        this.fYExternalRange = this.getRange(yAxisAspects, true);
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double logScaleEpsilon = 0.0;
        if (logscale) {
            for (LamiTableEntryAspect aspect : yAxisAspects) {
                for (LamiTableEntry entry : entries) {
                    Double value;
                    Number externalValue = aspect.resolveNumber(entry);
                    if (externalValue == null || (value = Double.valueOf(LamiBarChartViewer.getInternalDoubleValue(externalValue, this.fYInternalRange, this.fYExternalRange))) <= 0.0) continue;
                    min = Math.min(min, value);
                    max = Math.max(max, value);
                }
            }
            if (min == Double.MAX_VALUE) {
                return;
            }
            double delta = max - min;
            logScaleEpsilon = min - min * delta / (100.0 * max);
        }
        for (LamiTableEntryAspect yAxisAspect : yAxisAspects) {
            if (!yAxisAspect.isContinuous() || yAxisAspect.isTimeStamp()) continue;
            ArrayList<Double> validXValues = new ArrayList<Double>();
            ArrayList<Double> validYValues = new ArrayList<Double>();
            ArrayList<Mapping> indexMapping = new ArrayList<Mapping>();
            int i2 = 0;
            while (i2 < entries.size()) {
                Integer categoryIndex = ((Mapping)NonNullUtils.checkNotNull((Object)this.fEntryToCategoriesMap.get(NonNullUtils.checkNotNull((Object)((LamiTableEntry)entries.get(i2)))))).fInternalValue;
                if (categoryIndex != null) {
                    Double yValue = 0.0;
                    @Nullable Number number = yAxisAspect.resolveNumber((LamiTableEntry)entries.get(i2));
                    yValue = number == null ? Double.valueOf(0.0) : Double.valueOf(LamiBarChartViewer.getInternalDoubleValue(number, this.fYInternalRange, this.fYExternalRange));
                    if (logscale && yValue <= 0.0) {
                        yValue = (min + logScaleEpsilon) / 2.0;
                    }
                    validXValues.add(((Integer)NonNullUtils.checkNotNull((Object)categoryIndex)).doubleValue());
                    validYValues.add(yValue);
                    indexMapping.add(new Mapping(categoryIndex, ((Mapping)NonNullUtils.checkNotNull((Object)this.fEntryToCategoriesMap.get(NonNullUtils.checkNotNull((Object)((LamiTableEntry)entries.get(i2)))))).fModelValue));
                }
                ++i2;
            }
            String name = yAxisAspect.getLabel();
            if (validXValues.isEmpty() || validYValues.isEmpty()) continue;
            IBarSeries barSeries = (IBarSeries)this.getChart().getSeriesSet().createSeries(ISeries.SeriesType.BAR, name);
            barSeries.setXSeries(validXValues.stream().mapToDouble(Double::doubleValue).toArray());
            barSeries.setYSeries(validYValues.stream().mapToDouble(Double::doubleValue).toArray());
            this.fIndexPerSeriesMapping.put((ISeries)barSeries, indexMapping);
        }
        this.setBarSeriesColors();
        Stream.of(this.getChart().getAxisSet().getYAxes()).forEach(axis -> axis.enableLogScale(logscale));
        IAxisTick yTick = this.getChart().getAxisSet().getYAxis(0).getTick();
        yTick.setFormat(LamiBarChartViewer.getContinuousAxisFormatter(yAxisAspects, entries, this.fYInternalRange, this.fYExternalRange));
        yTick.setTickLabelAngle(1);
        this.getChart().getAxisSet().adjustRange();
        if (logscale && logScaleEpsilon != max) {
            this.getChart().getAxisSet().getYAxis(0).setRange(new Range(logScaleEpsilon, max));
        }
        this.refreshDisplayLabels();
        this.getChart().getPlotArea().addMouseListener((MouseListener)new LamiBarChartMouseDownListener());
        this.getChart().getPlotArea().addPaintListener((PaintListener)new LamiBarChartPainterListener());
    }

    @Override
    protected void redraw() {
        this.setBarSeriesColors();
        super.redraw();
    }

    private void setBarSeriesColors() {
        Iterator colorsIt = this.isSelected() ? Iterators.cycle((Iterable)LIGHT_COLORS) : Iterators.cycle((Iterable)COLORS);
        ISeries[] iSeriesArray = this.getChart().getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            ((IBarSeries)series).setBarColor((Color)colorsIt.next());
            ++n2;
        }
    }

    @Override
    protected void refreshDisplayLabels() {
        if (this.fCategories.length == 0) {
            return;
        }
        IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
        if (!xAxis.getTick().isVisible() || !xAxis.isCategoryEnabled()) {
            return;
        }
        Rectangle rect = this.getChart().getClientArea();
        int lengthLimit = (int)((double)rect.height * 0.4);
        GC gc = new GC((Drawable)this.fParent);
        gc.setFont(xAxis.getTick().getFont());
        String longestString = Arrays.stream(this.fCategories).max(Comparator.comparingInt(String::length)).orElse(this.fCategories[0]);
        Point pixels = gc.stringExtent(longestString);
        int cutLen = 5;
        String[] displayCategories = new String[this.fCategories.length];
        if (pixels.x > lengthLimit) {
            int i = 0;
            while (i < this.fCategories.length) {
                displayCategories[i] = this.fCategories[i].length() > cutLen ? String.valueOf(this.fCategories[i].substring(0, cutLen)) + "\u2026" : this.fCategories[i];
                ++i;
            }
        } else {
            displayCategories = Arrays.copyOf(this.fCategories, this.fCategories.length);
        }
        xAxis.setCategorySeries(displayCategories);
        gc.dispose();
    }

    private int getTableEntryIndexFromGraphIndex(ISeries series, int index) {
        List<Mapping> indexes = this.fIndexPerSeriesMapping.get(series);
        if (indexes == null || index > indexes.size() || index < 0) {
            return -1;
        }
        Mapping mapping = indexes.get(index);
        Integer modelValue = mapping.getModelValue();
        if (modelValue != null) {
            return modelValue;
        }
        return -1;
    }

    private int getGraphIndexFromTableEntryIndex(ISeries series, int index) {
        List<Mapping> indexes = this.fIndexPerSeriesMapping.get(series);
        if (indexes == null || index < 0) {
            return -1;
        }
        int internalIndex = -1;
        for (Mapping mapping : indexes) {
            Integer internalValue;
            if (mapping.getModelValue() != index || (internalValue = mapping.getInternalValue()) == null) continue;
            internalIndex = internalValue;
            break;
        }
        return internalIndex;
    }

    private final class LamiBarChartMouseDownListener
    extends MouseAdapter {
        private LamiBarChartMouseDownListener() {
        }

        public void mouseDown(@Nullable MouseEvent event) {
            ISeries[] series;
            Set<Integer> selections;
            if (event == null || event.button != 1) {
                return;
            }
            boolean ctrlMode = false;
            int xMouseLocation = event.x;
            int yMouseLocation = event.y;
            if ((event.stateMask & 0x40000) != 0) {
                ctrlMode = true;
                selections = LamiBarChartViewer.this.getSelection();
            } else {
                LamiBarChartViewer.this.unsetSelection();
                selections = new HashSet<Integer>();
            }
            ISeries[] iSeriesArray = series = LamiBarChartViewer.this.getChart().getSeriesSet().getSeries();
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries oneSeries = iSeriesArray[n2];
                IBarSeries barSerie = (IBarSeries)oneSeries;
                Rectangle[] recs = barSerie.getBounds();
                int j = 0;
                while (j < recs.length) {
                    Rectangle rectangle = recs[j];
                    if (rectangle.contains(xMouseLocation, yMouseLocation)) {
                        int index = LamiBarChartViewer.this.getTableEntryIndexFromGraphIndex((ISeries)NonNullUtils.checkNotNull((Object)oneSeries), j);
                        if (!ctrlMode || index >= 0 && !selections.remove(index)) {
                            selections.add(index);
                        }
                    }
                    ++j;
                }
                ++n2;
            }
            LamiBarChartViewer.this.setSelection(selections);
            LamiSelectionUpdateSignal signal = new LamiSelectionUpdateSignal((Object)this, selections, LamiBarChartViewer.this.getResultTable().hashCode());
            TmfSignalManager.dispatchSignal((TmfSignal)signal);
            LamiBarChartViewer.this.redraw();
        }
    }

    private final class LamiBarChartPainterListener
    implements PaintListener {
        private LamiBarChartPainterListener() {
        }

        public void paintControl(@Nullable PaintEvent e) {
            if (e == null || !LamiBarChartViewer.this.isSelected()) {
                return;
            }
            Iterator colorsIt = Iterators.cycle((Iterable)COLORS);
            GC gc = e.gc;
            ISeries[] iSeriesArray = LamiBarChartViewer.this.getChart().getSeriesSet().getSeries();
            int n = iSeriesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries series = iSeriesArray[n2];
                Color color = (Color)colorsIt.next();
                for (int index : LamiBarChartViewer.this.getSelection()) {
                    Rectangle[] bounds;
                    int graphIndex = LamiBarChartViewer.this.getGraphIndexFromTableEntryIndex(series, index);
                    if (graphIndex < 0 || (bounds = ((IBarSeries)series).getBounds()).length != LamiBarChartViewer.this.fCategories.length) continue;
                    Rectangle rectangle = bounds[graphIndex];
                    gc.setBackground(color);
                    gc.fillRectangle(rectangle);
                }
                ++n2;
            }
        }
    }

    private class Mapping {
        private final @Nullable Integer fInternalValue;
        private final @Nullable Integer fModelValue;

        public Mapping(@Nullable Integer internalValue, Integer modelValue) {
            this.fInternalValue = internalValue;
            this.fModelValue = modelValue;
        }

        public @Nullable Integer getInternalValue() {
            return this.fInternalValue;
        }

        public @Nullable Integer getModelValue() {
            return this.fModelValue;
        }
    }
}

