/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.AbstractSegmentStoreAnalysisModule;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.store.ArrayListStore;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.ISegmentListener;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class XmlPatternSegmentStoreModule
extends AbstractSegmentStoreAnalysisModule
implements ISegmentListener {
    public static final @NonNull EndSegment END_SEGMENT = new EndSegment();
    private final ISegmentStore<@NonNull ISegment> fSegments = new ArrayListStore();
    private final CountDownLatch fFinished = new CountDownLatch(1);
    private final @NonNull XmlPatternAnalysis fParent;
    private boolean fSegmentStoreCompleted;

    public XmlPatternSegmentStoreModule(@NonNull XmlPatternAnalysis parent) {
        this.fParent = parent;
    }

    protected Object @NonNull [] readObject(@NonNull ObjectInputStream ois) throws ClassNotFoundException, IOException {
        return (Object[])NonNullUtils.checkNotNull((Object)((Object[])ois.readObject()));
    }

    protected boolean buildAnalysisSegments(@NonNull ISegmentStore<@NonNull ISegment> segments, @NonNull IProgressMonitor monitor) throws TmfAnalysisException {
        @Nullable ITmfTrace trace = this.getTrace();
        if (trace == null) {
            this.segmentStoreReady(false);
            segments.close(true);
            return false;
        }
        if (this.waitForSegmentStoreCompletion()) {
            segments.addAll(this.getSegments());
            segments.close(false);
            return true;
        }
        segments.close(true);
        return false;
    }

    protected void canceling() {
        super.cancel();
        this.segmentStoreReady(false);
    }

    protected @Nullable String getDataFileName() {
        return String.valueOf(this.getId()) + ".dat";
    }

    protected void sendUpdate(ISegmentStore<@NonNull ISegment> store) {
        for (IAnalysisProgressListener listener : this.getListeners()) {
            listener.onComplete((ISegmentStoreProvider)this.fParent, store);
        }
    }

    @Override
    public void onNewSegment(@NonNull ISegment segment) {
        if (!this.fSegmentStoreCompleted) {
            if (segment == END_SEGMENT) {
                this.segmentStoreReady(true);
                return;
            }
            this.getSegments().add((Object)segment);
        }
    }

    private synchronized ISegmentStore<@NonNull ISegment> getSegments() {
        return this.fSegments;
    }

    public boolean waitForSegmentStoreCompletion() {
        try {
            this.fFinished.await();
        }
        catch (InterruptedException e) {
            return false;
        }
        return this.fSegmentStoreCompleted;
    }

    private void segmentStoreReady(boolean succeeded) {
        this.fSegmentStoreCompleted = succeeded;
        this.fFinished.countDown();
    }

    public static class EndSegment
    implements ISegment {
        private static final long serialVersionUID = 7834984029618274707L;

        public long getStart() {
            return Long.MIN_VALUE;
        }

        public long getEnd() {
            return Long.MIN_VALUE;
        }
    }
}

