/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.statesystem.core.Attribute;
import org.eclipse.tracecompass.internal.statesystem.core.StateSystem;

public final class AttributeTree {
    private static final int ATTRIB_TREE_MAGIC_NUMBER = 116143729;
    private static final String SERIALIZATION_WILDCARD = "*";
    private final StateSystem ss;
    private final List<Attribute> attributeList;
    private final Attribute attributeTreeRoot;

    public AttributeTree(StateSystem ss) {
        this.ss = ss;
        this.attributeList = new ArrayList<Attribute>();
        this.attributeTreeRoot = new Attribute(null, "root", -1);
    }

    public AttributeTree(StateSystem ss, FileInputStream fis) throws IOException {
        this(ss);
        ArrayList attribList;
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(fis));
        int res = ois.readInt();
        if (res != 116143729) {
            throw new IOException("The attribute tree file section is either invalid or corrupted.");
        }
        try {
            ArrayList list;
            attribList = list = (ArrayList)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unrecognizable attribute list");
        }
        String[] prevFullAttribute = null;
        String[] curFullAttribute = null;
        for (String[] attrib : attribList) {
            curFullAttribute = AttributeTree.decodeFullAttribute(prevFullAttribute, attrib);
            this.getQuarkAndAdd(-1, curFullAttribute);
            prevFullAttribute = curFullAttribute;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void writeSelf(File file, long pos) {
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                FileOutputStream fos = new FileOutputStream(file, true);
                try {
                    try (FileChannel fc = fos.getChannel();){
                        fc.position(pos);
                        Throwable throwable2 = null;
                        Object var9_13 = null;
                        try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
                            oos.writeInt(116143729);
                            ArrayList<String[]> list = new ArrayList<String[]>(this.attributeList.size());
                            String[] prevFullAttribute = null;
                            String[] curFullAttribute = null;
                            String[] curEncodedAttribute = null;
                            for (Attribute entry : this.attributeList) {
                                curFullAttribute = entry.getFullAttribute();
                                curEncodedAttribute = AttributeTree.encodeFullAttribute(prevFullAttribute, entry.getFullAttribute());
                                list.add(curEncodedAttribute);
                                prevFullAttribute = curFullAttribute;
                            }
                            oos.writeObject(list);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String[] encodeFullAttribute(String[] prevPath, String[] curPath) {
        if (prevPath == null) {
            return curPath;
        }
        String[] diff = new String[curPath.length];
        int i = 0;
        while (i < curPath.length) {
            diff[i] = i < prevPath.length && prevPath[i].equals(curPath[i]) ? SERIALIZATION_WILDCARD : curPath[i];
            ++i;
        }
        return diff;
    }

    private static String[] decodeFullAttribute(String[] prevPath, String[] curPath) {
        if (prevPath == null) {
            return curPath;
        }
        String[] diff = new String[curPath.length];
        int i = 0;
        while (i < curPath.length) {
            diff[i] = i < prevPath.length && curPath[i].equals(SERIALIZATION_WILDCARD) ? prevPath[i] : curPath[i];
            ++i;
        }
        return diff;
    }

    public synchronized int getNbAttributes() {
        return this.attributeList.size();
    }

    public synchronized int getQuarkDontAdd(int startingNodeQuark, String ... subPath) {
        if (subPath == null || subPath.length == 0) {
            return startingNodeQuark;
        }
        Attribute prevNode = startingNodeQuark == -1 ? this.attributeTreeRoot : this.attributeList.get(startingNodeQuark);
        return prevNode.getSubAttributeQuark(subPath);
    }

    public synchronized int getQuarkAndAdd(int startingNodeQuark, String ... subPath) {
        Attribute nextNode = null;
        Attribute prevNode = startingNodeQuark == -1 ? this.attributeTreeRoot : this.attributeList.get(startingNodeQuark);
        int knownQuark = prevNode.getSubAttributeQuark(subPath);
        if (knownQuark == -2) {
            String[] stringArray = subPath;
            int n = subPath.length;
            int n2 = 0;
            while (n2 < n) {
                String curDirectory = stringArray[n2];
                nextNode = prevNode.getSubAttributeNode(curDirectory);
                if (nextNode == null) {
                    nextNode = new Attribute(prevNode, (String)NonNullUtils.checkNotNull((Object)curDirectory), this.attributeList.size());
                    prevNode.addSubAttribute(nextNode);
                    this.attributeList.add(nextNode);
                    this.ss.addEmptyAttribute();
                }
                prevNode = nextNode;
                ++n2;
            }
            return this.attributeList.size() - 1;
        }
        return knownQuark;
    }

    public synchronized @NonNull List<@NonNull Integer> getSubAttributes(int attributeQuark, boolean recursive) {
        ArrayList<@NonNull Integer> listOfChildren = new ArrayList<Integer>();
        Attribute startingAttribute = attributeQuark == -1 ? this.attributeTreeRoot : this.attributeList.get(attributeQuark);
        this.addSubAttributes(listOfChildren, startingAttribute, recursive);
        return listOfChildren;
    }

    public synchronized int getParentAttributeQuark(int quark) {
        if (quark == -1) {
            return quark;
        }
        return this.attributeList.get(quark).getParentAttributeQuark();
    }

    private void addSubAttributes(List<Integer> list, Attribute curAttribute, boolean recursive) {
        for (Attribute childNode : curAttribute.getSubAttributes()) {
            list.add(childNode.getQuark());
            if (!recursive) continue;
            this.addSubAttributes(list, childNode, true);
        }
    }

    public synchronized @NonNull String getAttributeName(int quark) {
        return this.attributeList.get(quark).getName();
    }

    public synchronized @NonNull String getFullAttributeName(int quark) {
        return this.attributeList.get(quark).getFullAttributeName();
    }

    public synchronized String @NonNull [] getFullAttributePathArray(int quark) {
        return this.attributeList.get(quark).getFullAttribute();
    }

    public synchronized void debugPrint(PrintWriter writer) {
        this.attributeTreeRoot.debugPrint(writer);
    }
}

