/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.internal.ui.DialogSettingsHelper;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@Deprecated
public class MultipleInputDialog
extends Dialog {
    protected static final String FIELD_NAME = "FIELD_NAME";
    protected static final int TEXT = 100;
    protected static final int BROWSE = 101;
    protected static final int VARIABLE = 102;
    protected Composite panel;
    protected List<FieldSummary> fieldList = new ArrayList<FieldSummary>();
    protected List<Text> controlList = new ArrayList<Text>();
    protected List<Validator> validators = new ArrayList<Validator>();
    protected Map<Object, String> valueMap = new HashMap<Object, String>();
    private String title;

    public MultipleInputDialog(Shell shell, String title) {
        super(shell);
        this.title = title;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.validateFields();
        return bar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        this.panel = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        this.panel.setLayout((Layout)layout);
        this.panel.setLayoutData((Object)new GridData(768));
        for (FieldSummary field : this.fieldList) {
            switch (field.type) {
                case 100: {
                    this.createTextField(field.name, field.initialValue, field.allowsEmpty);
                    break;
                }
                case 101: {
                    this.createBrowseField(field.name, field.initialValue, field.allowsEmpty);
                    break;
                }
                case 102: {
                    this.createVariablesField(field.name, field.initialValue, field.allowsEmpty);
                }
            }
        }
        this.fieldList = null;
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    public void addBrowseField(String labelText, String initialValue, boolean allowsEmpty) {
        this.fieldList.add(new FieldSummary(101, labelText, initialValue, allowsEmpty));
    }

    public void addTextField(String labelText, String initialValue, boolean allowsEmpty) {
        this.fieldList.add(new FieldSummary(100, labelText, initialValue, allowsEmpty));
    }

    public void addVariablesField(String labelText, String initialValue, boolean allowsEmpty) {
        this.fieldList.add(new FieldSummary(102, labelText, initialValue, allowsEmpty));
    }

    protected void createTextField(String labelText, String initialValue, boolean allowEmpty) {
        Label label = new Label(this.panel, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(32));
        final Text text = new Text(this.panel, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setData(FIELD_NAME, (Object)labelText);
        label.setSize(label.getSize().x, text.getSize().y);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (!allowEmpty) {
            this.validators.add(new Validator(this){

                @Override
                public boolean validate() {
                    return !text.getText().isEmpty();
                }
            });
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        this.controlList.add(text);
    }

    protected void createBrowseField(String labelText, String initialValue, boolean allowEmpty) {
        Label label = new Label(this.panel, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(32));
        Composite comp = new Composite(this.panel, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        final Text text = new Text(comp, 2052);
        GridData data = new GridData(768);
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        text.setData(FIELD_NAME, (Object)labelText);
        label.setSize(label.getSize().x, text.getSize().y);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (!allowEmpty) {
            this.validators.add(new Validator(this){

                @Override
                public boolean validate() {
                    return !text.getText().isEmpty();
                }
            });
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        Button button = this.createButton(comp, 9, MakeUIPlugin.getResourceString("MultipleInputDialog.0"), false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedDirectory;
                File path;
                DirectoryDialog dialog = new DirectoryDialog(MultipleInputDialog.this.getShell());
                dialog.setMessage(MakeUIPlugin.getResourceString("MultipleInputDialog.1"));
                String currentWorkingDir = text.getText();
                if (!currentWorkingDir.trim().isEmpty() && (path = new File(currentWorkingDir)).exists()) {
                    dialog.setFilterPath(currentWorkingDir);
                }
                if ((selectedDirectory = dialog.open()) != null) {
                    text.setText(selectedDirectory);
                }
            }
        });
        this.controlList.add(text);
    }

    public void createVariablesField(String labelText, String initialValue, boolean allowEmpty) {
        Label label = new Label(this.panel, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(32));
        Composite comp = new Composite(this.panel, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        final Text text = new Text(comp, 2052);
        GridData data = new GridData(768);
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        text.setData(FIELD_NAME, (Object)labelText);
        label.setSize(label.getSize().x, text.getSize().y);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (!allowEmpty) {
            this.validators.add(new Validator(this){

                @Override
                public boolean validate() {
                    return !text.getText().isEmpty();
                }
            });
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        Button button = this.createButton(comp, 9, MakeUIPlugin.getResourceString("MultipleInputDialog.2"), false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String variable;
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(MultipleInputDialog.this.getShell());
                int code = dialog.open();
                if (code == 0 && (variable = dialog.getVariableExpression()) != null) {
                    text.insert(variable);
                }
            }
        });
        this.controlList.add(text);
    }

    protected void okPressed() {
        for (Text control : this.controlList) {
            this.valueMap.put(control.getData(FIELD_NAME), control.getText());
        }
        this.controlList = null;
        super.okPressed();
    }

    public int open() {
        MultipleInputDialog.applyDialogFont((Control)this.panel);
        return super.open();
    }

    public Object getValue(String key) {
        return this.valueMap.get(key);
    }

    public String getStringValue(String key) {
        return (String)this.getValue(key);
    }

    public void validateFields() {
        for (Validator validator : this.validators) {
            if (validator.validate()) continue;
            this.getButton(0).setEnabled(false);
            return;
        }
        this.getButton(0).setEnabled(true);
    }

    protected Point getInitialLocation(Point initialSize) {
        Point initialLocation = DialogSettingsHelper.getInitialLocation(this.getDialogSettingsSectionName());
        if (initialLocation != null) {
            return initialLocation;
        }
        return super.getInitialLocation(initialSize);
    }

    protected String getDialogSettingsSectionName() {
        return String.valueOf(MakeUIPlugin.getPluginId()) + ".MULTIPLE_INPUT_DIALOG_2";
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        return DialogSettingsHelper.getInitialSize(this.getDialogSettingsSectionName(), size);
    }

    public boolean close() {
        DialogSettingsHelper.persistShellGeometry(this.getShell(), this.getDialogSettingsSectionName());
        return super.close();
    }

    protected class FieldSummary {
        int type;
        String name;
        String initialValue;
        boolean allowsEmpty;

        public FieldSummary(int type, String name, String initialValue, boolean allowsEmpty) {
            this.type = type;
            this.name = name;
            this.initialValue = initialValue;
            this.allowsEmpty = allowsEmpty;
        }
    }

    protected class Validator {
        protected Validator() {
        }

        boolean validate() {
            return true;
        }
    }
}

