/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.io.File;
import java.util.List;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.internal.core.scannerconfig.jobs.BuildOutputReaderJob;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.dialogs.AbstractDiscoveryPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GCCPerFileSCDProfilePage
extends AbstractDiscoveryPage {
    private Button bopEnabledButton;
    private Text bopOpenFileText;
    private Button bopLoadButton;
    private static Object lock = GCCPerFileSCDProfilePage.class;
    private Shell shell;
    private static GCCPerFileSCDProfilePage instance;
    private static boolean loadButtonInitialEnabled;

    static {
        loadButtonInitialEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createControl(Composite parent) {
        Composite page = ControlFactory.createComposite((Composite)parent, (int)1);
        Group profileGroup = ControlFactory.createGroup((Composite)page, (String)MakeUIPlugin.getResourceString("ScannerConfigOptionsDialog.profile.group.label"), (int)3);
        GridData gd = (GridData)profileGroup.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        ((GridLayout)profileGroup.getLayout()).makeColumnsEqualWidth = false;
        this.bopEnabledButton = ControlFactory.createCheckBox((Composite)profileGroup, (String)B_ENABLE);
        ((GridData)this.bopEnabledButton.getLayoutData()).horizontalSpan = 3;
        ((GridData)this.bopEnabledButton.getLayoutData()).grabExcessHorizontalSpace = true;
        this.bopEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GCCPerFileSCDProfilePage.this.handleModifyOpenFileText();
            }
        });
        Label loadLabel = ControlFactory.createLabel((Composite)profileGroup, (String)L_OPEN);
        ((GridData)loadLabel.getLayoutData()).horizontalSpan = 2;
        this.bopLoadButton = ControlFactory.createPushButton((Composite)profileGroup, (String)B_LOAD);
        ((GridData)this.bopLoadButton.getLayoutData()).minimumWidth = 120;
        this.bopLoadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GCCPerFileSCDProfilePage.this.handleBOPLoadFileButtonSelected();
            }
        });
        if (this.getContainer().getProject() == null) {
            this.bopLoadButton.setVisible(false);
        }
        this.bopOpenFileText = ControlFactory.createTextField((Composite)profileGroup, (int)2052);
        this.bopOpenFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GCCPerFileSCDProfilePage.this.handleModifyOpenFileText();
            }
        });
        this.bopLoadButton.setEnabled(loadButtonInitialEnabled && this.handleModifyOpenFileText());
        Button browseButton = ControlFactory.createPushButton((Composite)profileGroup, (String)B_BROWSE);
        ((GridData)browseButton.getLayoutData()).minimumWidth = 120;
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.handleBOPBrowseButtonSelected();
            }

            private void handleBOPBrowseButtonSelected() {
                IPath filterPath;
                FileDialog dialog = new FileDialog(GCCPerFileSCDProfilePage.this.getShell(), 0);
                dialog.setText(F_OPEN);
                String fileName = GCCPerFileSCDProfilePage.this.getBopOpenFileText();
                if (fileName.length() == 0 && GCCPerFileSCDProfilePage.this.getContainer().getProject() != null) {
                    filterPath = GCCPerFileSCDProfilePage.this.getContainer().getProject().getLocation();
                } else {
                    Path filePath = new Path(fileName);
                    filterPath = filePath.removeLastSegments(1).makeAbsolute();
                }
                dialog.setFilterPath(filterPath.toOSString());
                String res = dialog.open();
                if (res == null) {
                    return;
                }
                GCCPerFileSCDProfilePage.this.setBopOpenFileText(res);
            }
        });
        this.addVariablesButton((Composite)profileGroup, this.bopOpenFileText);
        this.setControl((Control)page);
        Object object = lock;
        synchronized (object) {
            this.shell = this.getShell();
            instance = this;
        }
        this.initializeValues();
    }

    protected boolean handleModifyOpenFileText() {
        String fileName = this.getBopOpenFileText();
        this.bopLoadButton.setEnabled(this.bopEnabledButton.getSelection() && fileName.length() > 0 && new File(fileName).exists());
        return this.bopLoadButton.getEnabled();
    }

    private String getBopOpenFileText() {
        Path filePath;
        String fileName = this.bopOpenFileText.getText().trim();
        if (fileName.length() > 0 && !(filePath = new Path(fileName)).isAbsolute() && this.getContainer().getProject() != null) {
            IPath projectPath = this.getContainer().getProject().getLocation();
            filePath = projectPath.append((IPath)filePath);
            fileName = filePath.toString();
        }
        return fileName;
    }

    private void setBopOpenFileText(String fileName) {
        IPath projectPath;
        Path filePath;
        if (fileName.length() > 0 && (filePath = new Path(fileName)).isAbsolute() && this.getContainer().getProject() != null && (projectPath = this.getContainer().getProject().getLocation()).isPrefixOf((IPath)filePath)) {
            filePath = filePath.removeFirstSegments(projectPath.segmentCount());
            filePath = filePath.setDevice(null);
            fileName = filePath.toString();
        }
        this.bopOpenFileText.setText(fileName);
    }

    private void initializeValues() {
        this.bopEnabledButton.setSelection(this.getContainer().getBuildInfo().isBuildOutputParserEnabled());
        this.setBopOpenFileText(this.getContainer().getBuildInfo().getBuildOutputFilePath());
    }

    private void handleBOPLoadFileButtonSelected() {
        if (!this.getContainer().checkDialogForChanges()) {
            return;
        }
        loadButtonInitialEnabled = false;
        this.bopLoadButton.setEnabled(false);
        this.populateBuildInfo(this.getContainer().getBuildInfo());
        IProject project = this.getContainer().getProject();
        BuildOutputReaderJob readerJob = new BuildOutputReaderJob(project, this.getContainer().getBuildInfo());
        readerJob.setPriority(30);
        readerJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                Object object = lock;
                synchronized (object) {
                    if (!instance.shell.isDisposed()) {
                        instance.shell.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!instance.shell.isDisposed()) {
                                    loadButtonInitialEnabled = instance.bopEnabledButton.getSelection() && GCCPerFileSCDProfilePage.this.handleModifyOpenFileText();
                                    instance.bopLoadButton.setEnabled(loadButtonInitialEnabled);
                                } else {
                                    loadButtonInitialEnabled = true;
                                }
                            }
                        });
                    } else {
                        loadButtonInitialEnabled = true;
                    }
                }
            }
        });
        readerJob.schedule();
    }

    @Override
    protected boolean isValid() {
        return true;
    }

    @Override
    protected void populateBuildInfo(IScannerConfigBuilderInfo2 buildInfo) {
        if (buildInfo != null) {
            buildInfo.setBuildOutputFileActionEnabled(true);
            buildInfo.setBuildOutputFilePath(this.getBopOpenFileText());
            buildInfo.setBuildOutputParserEnabled(this.bopEnabledButton.getSelection());
            buildInfo.setProviderOutputParserEnabled(this.getProviderIDForSelectedProfile(), this.bopEnabledButton.getSelection());
        }
    }

    @Override
    protected void restoreFromBuildinfo(IScannerConfigBuilderInfo2 buildInfo) {
        if (buildInfo != null) {
            this.setBopOpenFileText(buildInfo.getBuildOutputFilePath());
            this.bopEnabledButton.setSelection(buildInfo.isBuildOutputParserEnabled());
        }
    }

    private String getProviderIDForSelectedProfile() {
        IScannerConfigBuilderInfo2 builderInfo = this.getContainer().getBuildInfo();
        List providerIDs = builderInfo.getProviderIdList();
        if (providerIDs.size() == 0) {
            return "";
        }
        return (String)providerIDs.iterator().next();
    }
}

