/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.di;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.IIdeFactory;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.handlers.CreateReportProcessorHandler;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.epp.logging.aeri.core.util.Logs;

public class ExtensionPointReportProcessorsCreationFunction
extends ContextFunction {
    public static final String EXT_REPORT_PROCESSORS = "org.eclipse.epp.logging.aeri.ide.processors";

    public Object compute(IEclipseContext context, String contextKey) {
        Preconditions.checkNotNull((Object)contextKey);
        IEclipseContext systemContext = SystemControl.getSystemContext();
        IExtensionRegistry registry = (IExtensionRegistry)systemContext.get(IExtensionRegistry.class);
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EXT_REPORT_PROCESSORS);
        ImmutableList.Builder builder = ImmutableList.builder();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IProcessorDescriptor descriptor = IIdeFactory.eINSTANCE.createProcessorDescriptor();
            descriptor.setConfigurationElement(element);
            descriptor.setDirective(element.getAttribute("directive"));
            descriptor.setName(element.getAttribute("name"));
            descriptor.setDescription(element.getAttribute("description"));
            descriptor.setIcon16(element.getAttribute("icon16"));
            descriptor.setContributor(element.getContributor().getName());
            descriptor.setAutomatic(Boolean.valueOf(element.getAttribute("isAutomatic")));
            try {
                IEclipseContext childContext = systemContext.createChild("Report processor context of '" + descriptor.getDirective() + "'");
                childContext.set(IProcessorDescriptor.class, (Object)descriptor);
                String providerClass = element.getAttribute("class");
                String contributor = element.getContributor().getName();
                ReportProcessorSafeWrapper processor = new CreateReportProcessorHandler().execute(providerClass, childContext, contributor);
                descriptor.setProcessor(processor);
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.WARN_EXTENSION_FAILED, (Throwable)e, (Object[])new Object[]{descriptor.getDirective(), e.getMessage()});
            }
            builder.add((Object)descriptor);
            ++n2;
        }
        ImmutableList descriptors = builder.build();
        systemContext.set(contextKey, (Object)descriptors);
        return descriptors;
    }
}

