/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import java.net.URI;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;

public abstract class ACBuilder
extends IncrementalProjectBuilder
implements IMarkerGenerator {
    private static final String CONTENTS_CONFIGURATION_IDS = "org.eclipse.cdt.make.core.configurationIds";
    private static final IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core");
    protected static final boolean DEBUG_EVENTS = false;
    private IProject currentProject;

    protected void setCurrentProject(IProject project) {
        this.currentProject = project;
    }

    protected IProject getCurrentProject() {
        if (this.currentProject != null) {
            return this.currentProject;
        }
        return super.getProject();
    }

    @Override
    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo(file, lineNumber, errorDesc, severity, errorVar, null);
        this.addMarker(problemMarkerInfo);
    }

    @Override
    public void addMarker(ProblemMarkerInfo problemMarkerInfo) {
        try {
            Map<String, String> attributes;
            IMarker[] markers;
            IProject project = this.getCurrentProject();
            IResource markerResource = problemMarkerInfo.file;
            if (markerResource == null) {
                markerResource = project;
            }
            String externalLocation = null;
            if (problemMarkerInfo.externalPath != null && !problemMarkerInfo.externalPath.isEmpty()) {
                externalLocation = problemMarkerInfo.externalPath.toOSString();
            }
            IMarker[] iMarkerArray = markers = markerResource.findMarkers("org.eclipse.cdt.core.problem", true, 1);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                String extloc;
                IMarker m = iMarkerArray[n2];
                int line = m.getAttribute("lineNumber", -1);
                int sev = m.getAttribute("severity", -1);
                String msg = (String)m.getAttribute("message");
                if (line == problemMarkerInfo.lineNumber && sev == this.mapMarkerSeverity(problemMarkerInfo.severity) && msg.equals(problemMarkerInfo.description) && ((extloc = (String)m.getAttribute("problem.externalLocation")) == externalLocation || extloc != null && extloc.equals(externalLocation))) {
                    if (project == null || project.equals((Object)markerResource.getProject())) {
                        return;
                    }
                    String source = (String)m.getAttribute("sourceId");
                    if (project.getName().equals(source)) {
                        return;
                    }
                }
                ++n2;
            }
            String type = problemMarkerInfo.getType();
            if (type == null) {
                type = "org.eclipse.cdt.core.problem";
            }
            IMarker marker = markerResource.createMarker(type);
            marker.setAttribute("message", (Object)problemMarkerInfo.description);
            marker.setAttribute("severity", this.mapMarkerSeverity(problemMarkerInfo.severity));
            marker.setAttribute("lineNumber", problemMarkerInfo.lineNumber);
            marker.setAttribute("charStart", problemMarkerInfo.startChar);
            marker.setAttribute("charEnd", problemMarkerInfo.endChar);
            if (problemMarkerInfo.variableName != null) {
                marker.setAttribute("problem.variable", (Object)problemMarkerInfo.variableName);
            }
            if (externalLocation != null) {
                URI uri = URIUtil.toURI((String)externalLocation);
                if (uri.getScheme() != null) {
                    marker.setAttribute("problem.externalLocation", (Object)externalLocation);
                    String locationText = NLS.bind((String)CCorePlugin.getResourceString("ACBuilder.ProblemsView.Location"), (Object)problemMarkerInfo.lineNumber, (Object)externalLocation);
                    marker.setAttribute("location", (Object)locationText);
                }
            } else if (problemMarkerInfo.lineNumber == 0) {
                marker.setAttribute("location", (Object)" ");
            }
            if (project != null && !project.equals((Object)markerResource.getProject())) {
                marker.setAttribute("sourceId", (Object)project.getName());
            }
            if ((attributes = problemMarkerInfo.getAttributes()) != null) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    marker.setAttribute(entry.getKey(), (Object)entry.getValue());
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    private int mapMarkerSeverity(int severity) {
        switch (severity) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    public static boolean needAllConfigBuild() {
        return prefs.getBoolean("build.all.configs.enabled", false);
    }

    public static void setAllConfigBuild(boolean enable) {
        prefs.putBoolean("build.all.configs.enabled", enable);
    }

    public static boolean buildConfigResourceChanges() {
        return prefs.getBoolean("build.proj.ref.configs.enabled", false);
    }

    public static void setBuildConfigResourceChanges(boolean enable) {
        prefs.putBoolean("build.proj.ref.configs.enabled", enable);
    }

    private static String kindToString(int kind) {
        return String.valueOf(kind == 9 ? "AUTO_BUILD" : (kind == 15 ? "CLEAN_BUILD" : (kind == 6 ? "FULL_BUILD" : (kind == 10 ? "INCREMENTAL_BUILD" : "[unknown kind]")))) + "=" + kind;
    }

    private String cfgIdToNames(String strIds) {
        IProject project = this.getCurrentProject();
        ICProjectDescription prjDesc = CoreModel.getDefault().getProjectDescription(project, false);
        if (prjDesc == null) {
            return strIds;
        }
        if (strIds == null) {
            return "Active=" + prjDesc.getActiveConfiguration().getName();
        }
        String[] ids = strIds.split("\\|");
        String names = "";
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            ICConfigurationDescription cfgDesc = prjDesc.getConfigurationById(id);
            String name = cfgDesc != null ? cfgDesc.getName() : id;
            if (names.length() > 0) {
                names = String.valueOf(names) + ",";
            }
            names = String.valueOf(names) + name;
            ++n2;
        }
        if (names.isEmpty()) {
            return strIds;
        }
        return names;
    }

    protected void printEvent(int kind, Map<String, String> args) {
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
    }

    public ISchedulingRule getRule(int trigger, Map args) {
        return null;
    }
}

