/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.CenteredImageLabelProvider;
import org.eclipse.egit.ui.internal.components.CheckboxLabelProvider;
import org.eclipse.egit.ui.internal.components.ClickableCellEditor;
import org.eclipse.egit.ui.internal.components.ComboLabelingSupport;
import org.eclipse.egit.ui.internal.components.RefContentProposal;
import org.eclipse.egit.ui.internal.components.SelectionChangeListener;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class RefSpecPanel {
    private static final String IMAGE_ADD = "ADD";
    private static final String IMAGE_DELETE = "DELETE";
    private static final String IMAGE_TRASH = "TRASH";
    private static final String IMAGE_CLEAR = "CLEAR";
    private static final int TABLE_PREFERRED_HEIGHT = 165;
    private static final int TABLE_PREFERRED_WIDTH = 560;
    private static final int COLUMN_MODE_WEIGHT = 23;
    private static final int COLUMN_SRC_WEIGHT = 40;
    private static final int COLUMN_DST_WEIGHT = 40;
    private static final int COLUMN_FORCE_WEIGHT = 30;
    private static final int COLUMN_REMOVE_WEIGHT = 20;
    private final List<RefSpec> specs = new ArrayList<RefSpec>();
    private final Composite panel;
    private TableViewer tableViewer;
    private CellEditor modeCellEditor;
    private CellEditor localRefCellEditor;
    private CellEditor remoteRefCellEditor;
    private CellEditor forceUpdateCellEditor;
    private CellEditor removeSpecCellEditor;
    private int srcColumnIndex;
    private Button removeAllSpecButton;
    private Button forceUpdateAllButton;
    private Button creationButton;
    private Button addConfiguredButton;
    private Button addTagsButton;
    private Button addBranchesButton;
    private ControlDecoration creationSrcDecoration;
    private ControlDecoration creationDstDecoration;
    private ControlDecoration deleteRefDecoration;
    private Combo creationSrcCombo;
    private Combo creationDstCombo;
    private Combo deleteRefCombo;
    private Button deleteButton;
    private Repository localDb;
    private RemoteConfig remoteConfig;
    private Set<String> localRefNames = Collections.emptySet();
    private Set<String> remoteRefNames = Collections.emptySet();
    private List<RefSpec> predefinedConfigured = Collections.emptyList();
    private RefSpec predefinedBranches = null;
    private final RefContentProposalProvider remoteProposalProvider;
    private final RefContentProposalProvider localProposalProvider;
    private ComboLabelingSupport creationSrcComboSupport;
    private ComboLabelingSupport creationDstComboSupport;
    private ComboLabelingSupport deleteRefComboSupport;
    private final boolean pushSpecs;
    private final List<SelectionChangeListener> listeners = new LinkedList<SelectionChangeListener>();
    private final ImageRegistry imageRegistry;
    private boolean matchingAnyRefs;
    private RefSpec invalidSpec;
    private RefSpec invalidSpecSameDst;
    private String errorMessage;
    private Color errorBackgroundColor;
    private Color errorTextColor;

    private static boolean isDeleteRefSpec(Object element) {
        return ((RefSpec)element).getSource() == null;
    }

    private static boolean isValidRefExpression(String s) {
        if (RefSpec.isWildcard((String)s)) {
            return RefSpecPanel.isValidRefExpression(String.valueOf(s.substring(0, s.length() - 1)) + 'X');
        }
        return Repository.isValidRefName((String)s) || Repository.isValidRefName((String)("refs/heads/" + s)) || Repository.isValidRefName((String)("refs/tags/" + s));
    }

    private static RefSpec setRefSpecSource(RefSpec spec, String src) {
        String dst = RefSpec.isWildcard((String)src) ? RefSpecPanel.wildcardSpecComponent(spec.getDestination()) : RefSpecPanel.unwildcardSpecComponent(spec.getDestination(), src);
        return spec.setSourceDestination(src, dst);
    }

    private static RefSpec setRefSpecDestination(RefSpec spec, String dst) {
        String src = RefSpec.isWildcard((String)dst) ? RefSpecPanel.wildcardSpecComponent(spec.getSource()) : RefSpecPanel.unwildcardSpecComponent(spec.getSource(), dst);
        return spec.setSourceDestination(src, dst);
    }

    private static String wildcardSpecComponent(String comp) {
        int i;
        if (RefSpec.isWildcard((String)comp)) {
            return comp;
        }
        if (comp == null || (i = comp.lastIndexOf(47)) == -1) {
            return UIText.RefSpecPanel_refChooseSomeWildcard;
        }
        return String.valueOf(comp.substring(0, i + 1)) + '*';
    }

    private static String unwildcardSpecComponent(String comp, String other) {
        if (!RefSpec.isWildcard((String)comp)) {
            return comp;
        }
        if (other == null || other.length() == 0) {
            return "";
        }
        int i = other.lastIndexOf(47);
        return String.valueOf(comp.substring(0, comp.length() - 1)) + other.substring(i + 1);
    }

    private static List<RefContentProposal> createProposalsFilteredRemote(List<RefContentProposal> proposals) {
        ArrayList<RefContentProposal> result = new ArrayList<RefContentProposal>();
        for (RefContentProposal p : proposals) {
            String content = p.getContent();
            if (!content.equals("HEAD") && !content.startsWith("refs/heads/")) continue;
            result.add(p);
        }
        return result;
    }

    private static Image getDecorationImage(String key) {
        return FieldDecorationRegistry.getDefault().getFieldDecoration(key).getImage();
    }

    private static void setControlDecoration(ControlDecoration control, String imageKey, String description) {
        control.setImage(RefSpecPanel.getDecorationImage(imageKey));
        control.setDescriptionText(description);
        control.show();
    }

    public RefSpecPanel(Composite parent, boolean pushSpecs) {
        this.pushSpecs = pushSpecs;
        this.localProposalProvider = new RefContentProposalProvider(pushSpecs);
        this.remoteProposalProvider = new RefContentProposalProvider(false);
        this.imageRegistry = new ImageRegistry(parent.getDisplay());
        this.panel = new Composite(parent, 0);
        this.panel.setLayout((Layout)new GridLayout());
        this.safeCreateResources();
        this.createCreationPanel();
        if (pushSpecs) {
            this.createDeleteCreationPanel();
        }
        this.createPredefinedCreationPanel();
        this.createTableGroup();
        this.addRefSpecTableListener(new SelectionChangeListener(){

            @Override
            public void selectionChanged() {
                RefSpecPanel.this.validateSpecs();
            }
        });
        this.setEnable(false);
    }

    public void setEnable(boolean enable) {
        this.getControl().setEnabled(enable);
    }

    public void setAssistanceData(Repository localRepo, Collection<Ref> remoteRefs, RemoteConfig config) {
        this.localDb = localRepo;
        this.remoteConfig = config;
        List<RefContentProposal> remoteProposals = this.createContentProposals(remoteRefs, null);
        this.remoteProposalProvider.setProposals(remoteProposals);
        this.remoteRefNames = new HashSet<String>();
        for (RefContentProposal p : remoteProposals) {
            this.remoteRefNames.add(p.getContent());
        }
        Ref HEAD = null;
        try {
            HEAD = this.localDb.exactRef("HEAD");
        }
        catch (IOException e) {
            Activator.logError("Couldn't read HEAD from local repository", e);
        }
        List<RefContentProposal> localProposals = this.createContentProposals(this.localDb.getAllRefs().values(), HEAD);
        this.localProposalProvider.setProposals(localProposals);
        this.localRefNames = new HashSet<String>();
        for (RefContentProposal ref : localProposals) {
            this.localRefNames.add(ref.getContent());
        }
        List<RefContentProposal> localFilteredProposals = this.createProposalsFilteredLocal(localProposals);
        List<RefContentProposal> remoteFilteredProposals = RefSpecPanel.createProposalsFilteredRemote(remoteProposals);
        if (this.pushSpecs) {
            this.creationSrcComboSupport.setProposals(localFilteredProposals);
            this.creationDstComboSupport.setProposals(remoteFilteredProposals);
        } else {
            this.creationSrcComboSupport.setProposals(remoteFilteredProposals);
            this.creationDstComboSupport.setProposals(localFilteredProposals);
        }
        this.validateCreationPanel();
        if (this.pushSpecs) {
            this.deleteRefComboSupport.setProposals(remoteFilteredProposals);
            this.validateDeleteCreationPanel();
        }
        if (this.remoteConfig == null) {
            this.predefinedConfigured = Collections.emptyList();
        } else {
            this.predefinedConfigured = this.pushSpecs ? this.remoteConfig.getPushRefSpecs() : this.remoteConfig.getFetchRefSpecs();
            for (RefSpec spec : this.predefinedConfigured) {
                this.addRefSpec(spec);
            }
        }
        this.updateAddPredefinedButton(this.addConfiguredButton, this.predefinedConfigured);
        if (this.pushSpecs) {
            this.predefinedBranches = Transport.REFSPEC_PUSH_ALL;
        } else {
            String r = this.remoteConfig == null ? UIText.RefSpecPanel_refChooseRemoteName : this.remoteConfig.getName();
            this.predefinedBranches = new RefSpec("refs/heads/*:refs/remotes/" + r + "/*");
        }
        this.updateAddPredefinedButton(this.addBranchesButton, this.predefinedBranches);
        this.setEnable(true);
    }

    public Control getControl() {
        return this.panel;
    }

    public List<RefSpec> getRefSpecs() {
        return Collections.unmodifiableList(this.specs);
    }

    public boolean isEmpty() {
        return this.getRefSpecs().isEmpty();
    }

    public boolean isMatchingAnyRefs() {
        return this.matchingAnyRefs;
    }

    public void addRefSpec(RefSpec spec) {
        int i = this.indexOfSpec(spec);
        if (i != -1) {
            throw new IllegalArgumentException("RefSpec " + spec + " already exists.");
        }
        this.specs.add(spec);
        this.tableViewer.add((Object)spec);
        this.notifySpecsChanged();
    }

    public void removeRefSpec(RefSpec spec) {
        int i = this.indexOfSpec(spec);
        if (i == -1) {
            throw new IllegalArgumentException("RefSpec " + spec + " not found.");
        }
        this.specs.remove(i);
        this.tableViewer.remove((Object)spec);
        this.notifySpecsChanged();
    }

    public void setRefSpec(RefSpec oldSpec, RefSpec newSpec) {
        int oldI = this.indexOfSpec(oldSpec);
        if (oldI == -1) {
            throw new IllegalArgumentException("RefSpec " + oldSpec + " not found.");
        }
        int newI = this.indexOfSpec(newSpec);
        if (newI != -1) {
            throw new IllegalArgumentException("RefSpec " + newSpec + " already exists.");
        }
        this.specs.set(oldI, newSpec);
        this.tableViewer.refresh();
        this.notifySpecsChanged();
    }

    public void clearRefSpecs() {
        Object[] toRemove = this.specs.toArray(new RefSpec[0]);
        this.specs.clear();
        this.tableViewer.remove(toRemove);
        this.notifySpecsChanged();
    }

    public void addRefSpecTableListener(SelectionChangeListener listener) {
        this.listeners.add(listener);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isValid() {
        return this.errorMessage == null;
    }

    private int indexOfSpec(RefSpec spec) {
        int i = 0;
        while (i < this.specs.size()) {
            if (this.specs.get(i) == spec) break;
            ++i;
        }
        if (i == this.specs.size()) {
            return -1;
        }
        return i;
    }

    private void notifySpecsChanged() {
        for (SelectionChangeListener listener : this.listeners) {
            listener.selectionChanged();
        }
    }

    private void safeCreateResources() {
        this.imageRegistry.put(IMAGE_ADD, UIIcons.ELCL16_ADD);
        this.imageRegistry.put(IMAGE_DELETE, UIIcons.ELCL16_DELETE);
        this.imageRegistry.put(IMAGE_TRASH, UIIcons.ELCL16_TRASH);
        this.imageRegistry.put(IMAGE_CLEAR, UIIcons.ELCL16_CLEAR);
        this.errorBackgroundColor = new Color((Device)this.panel.getDisplay(), 255, 150, 150);
        this.errorTextColor = new Color((Device)this.panel.getDisplay(), 255, 0, 0);
        this.panel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RefSpecPanel.this.imageRegistry.dispose();
                RefSpecPanel.this.errorBackgroundColor.dispose();
                RefSpecPanel.this.errorTextColor.dispose();
            }
        });
    }

    private RefContentProposalProvider getRefsProposalProvider(boolean local) {
        return local ? this.localProposalProvider : this.remoteProposalProvider;
    }

    private void createCreationPanel() {
        Group creationPanel = new Group(this.panel, 0);
        creationPanel.setText(UIText.RefSpecPanel_creationGroup);
        creationPanel.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 2;
        creationPanel.setLayout((Layout)layout);
        new Label((Composite)creationPanel, 0).setText(UIText.RefSpecPanel_creationSrc);
        new Label((Composite)creationPanel, 0).setText(UIText.RefSpecPanel_creationDst);
        this.creationButton = new Button((Composite)creationPanel, 8);
        this.creationButton.setLayoutData((Object)new GridData(131072, 1024, false, false, 1, 2));
        this.creationButton.setImage(this.imageRegistry.get(IMAGE_ADD));
        this.creationButton.setText(UIText.RefSpecPanel_creationButton);
        this.creationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String src = RefSpecPanel.this.creationSrcComboSupport.getContent();
                String dst = RefSpecPanel.this.creationDstComboSupport.getContent();
                RefSpec spec = new RefSpec(String.valueOf(src) + ':' + dst);
                RefSpecPanel.this.addRefSpec(spec);
                RefSpecPanel.this.creationSrcCombo.setText("");
                RefSpecPanel.this.creationDstCombo.setText("");
            }
        });
        this.creationButton.setToolTipText(NLS.bind((String)UIText.RefSpecPanel_creationButtonDescription, (Object)this.typeString()));
        this.creationSrcDecoration = this.createAssistedDecoratedCombo((Composite)creationPanel, this.getRefsProposalProvider(this.pushSpecs), new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                RefSpecPanel.this.tryAutoCompleteSrcToDst();
            }
        });
        this.creationSrcCombo = (Combo)this.creationSrcDecoration.getControl();
        this.creationSrcCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.creationSrcCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    RefSpecPanel.this.tryAutoCompleteSrcToDst();
                }
            }
        });
        if (this.pushSpecs) {
            this.creationSrcCombo.setToolTipText(UIText.RefSpecPanel_srcPushDescription);
        } else {
            this.creationSrcCombo.setToolTipText(UIText.RefSpecPanel_srcFetchDescription);
        }
        this.creationSrcComboSupport = new ComboLabelingSupport(this.creationSrcCombo, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefSpecPanel.this.tryAutoCompleteSrcToDst();
            }
        });
        this.creationDstDecoration = this.createAssistedDecoratedCombo((Composite)creationPanel, this.getRefsProposalProvider(!this.pushSpecs), new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                RefSpecPanel.this.tryAutoCompleteDstToSrc();
            }
        });
        this.creationDstCombo = (Combo)this.creationDstDecoration.getControl();
        this.creationDstCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.creationDstCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    RefSpecPanel.this.tryAutoCompleteDstToSrc();
                }
            }
        });
        if (this.pushSpecs) {
            this.creationDstCombo.setToolTipText(UIText.RefSpecPanel_dstPushDescription);
        } else {
            this.creationDstCombo.setToolTipText(UIText.RefSpecPanel_dstFetchDescription);
        }
        this.creationDstComboSupport = new ComboLabelingSupport(this.creationDstCombo, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefSpecPanel.this.tryAutoCompleteDstToSrc();
            }
        });
        this.validateCreationPanel();
        ModifyListener validator = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RefSpecPanel.this.validateCreationPanel();
            }
        };
        this.creationSrcCombo.addModifyListener(validator);
        this.creationDstCombo.addModifyListener(validator);
        Control[] tabList = new Control[]{this.creationSrcCombo, this.creationDstCombo, this.creationButton};
        creationPanel.setTabList(tabList);
    }

    private void createDeleteCreationPanel() {
        Group deletePanel = new Group(this.panel, 0);
        deletePanel.setText(UIText.RefSpecPanel_deletionGroup);
        deletePanel.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 10;
        deletePanel.setLayout((Layout)layout);
        Label label = new Label((Composite)deletePanel, 0);
        label.setText(UIText.RefSpecPanel_deletionRef);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.deleteRefDecoration = this.createAssistedDecoratedCombo((Composite)deletePanel, this.getRefsProposalProvider(false), null);
        this.deleteRefCombo = (Combo)this.deleteRefDecoration.getControl();
        this.deleteRefCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.deleteRefCombo.setToolTipText(UIText.RefSpecPanel_dstDeletionDescription);
        this.deleteRefComboSupport = new ComboLabelingSupport(this.deleteRefCombo, null);
        this.deleteButton = new Button((Composite)deletePanel, 8);
        this.deleteButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.deleteButton.setImage(this.imageRegistry.get(IMAGE_DELETE));
        this.deleteButton.setText(UIText.RefSpecPanel_deletionButton);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefSpec spec = new RefSpec(String.valueOf(':') + RefSpecPanel.this.deleteRefComboSupport.getContent());
                RefSpecPanel.this.addRefSpec(spec);
                RefSpecPanel.this.deleteRefCombo.setText("");
            }
        });
        this.deleteButton.setToolTipText(UIText.RefSpecPanel_deletionButtonDescription);
        this.validateDeleteCreationPanel();
        this.deleteRefCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RefSpecPanel.this.validateDeleteCreationPanel();
            }
        });
    }

    private void createPredefinedCreationPanel() {
        Group predefinedPanel = new Group(this.panel, 0);
        predefinedPanel.setLayoutData((Object)new GridData(4, 4, true, false));
        predefinedPanel.setText(UIText.RefSpecPanel_predefinedGroup);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        predefinedPanel.setLayout((Layout)layout);
        this.addConfiguredButton = new Button((Composite)predefinedPanel, 8);
        this.addConfiguredButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addConfiguredButton.setText(NLS.bind((String)UIText.RefSpecPanel_predefinedConfigured, (Object)this.typeStringTitle()));
        this.addConfiguredButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefSpecPanel.this.addPredefinedRefSpecs(RefSpecPanel.this.predefinedConfigured);
            }
        });
        this.addConfiguredButton.setToolTipText(UIText.RefSpecPanel_predefinedConfiguredDescription);
        this.updateAddPredefinedButton(this.addConfiguredButton, this.predefinedConfigured);
        this.addBranchesButton = new Button((Composite)predefinedPanel, 8);
        this.addBranchesButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addBranchesButton.setText(UIText.RefSpecPanel_predefinedAll);
        this.addBranchesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefSpecPanel.this.addPredefinedRefSpecs(RefSpecPanel.this.predefinedBranches);
            }
        });
        this.addBranchesButton.setToolTipText(UIText.RefSpecPanel_predefinedAllDescription);
        this.updateAddPredefinedButton(this.addBranchesButton, this.predefinedBranches);
        this.addTagsButton = new Button((Composite)predefinedPanel, 8);
        this.addTagsButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addTagsButton.setText(UIText.RefSpecPanel_predefinedTags);
        this.addTagsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefSpecPanel.this.addPredefinedRefSpecs(Transport.REFSPEC_TAGS);
            }
        });
        this.addTagsButton.setToolTipText(UIText.RefSpecPanel_predefinedTagsDescription);
        this.updateAddPredefinedButton(this.addTagsButton, Transport.REFSPEC_TAGS);
        this.addRefSpecTableListener(new SelectionChangeListener(){

            @Override
            public void selectionChanged() {
                RefSpecPanel.this.updateAddPredefinedButton(RefSpecPanel.this.addConfiguredButton, RefSpecPanel.this.predefinedConfigured);
                RefSpecPanel.this.updateAddPredefinedButton(RefSpecPanel.this.addBranchesButton, RefSpecPanel.this.predefinedBranches);
                RefSpecPanel.this.updateAddPredefinedButton(RefSpecPanel.this.addTagsButton, Transport.REFSPEC_TAGS);
            }
        });
    }

    private ControlDecoration createAssistedDecoratedCombo(Composite parent, IContentProposalProvider proposalProvider, IContentProposalListener listener) {
        Combo combo = new Combo(parent, 4);
        ControlDecoration decoration = new ControlDecoration((Control)combo, 17408);
        ContentAssistCommandAdapter proposal = new ContentAssistCommandAdapter((Control)combo, (IControlContentAdapter)new ComboContentAdapter(), proposalProvider, null, null, true);
        proposal.setProposalAcceptanceStyle(2);
        if (listener != null) {
            proposal.addContentProposalListener(listener);
        }
        return decoration;
    }

    private void createTableGroup() {
        Group tableGroup = new Group(this.panel, 0);
        tableGroup.setText(NLS.bind((String)UIText.RefSpecPanel_specifications, (Object)this.typeString()));
        tableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        tableGroup.setLayout((Layout)new GridLayout());
        this.createTable(tableGroup);
        this.createSpecsButtonsPanel((Composite)tableGroup);
    }

    private void createTable(Group tableGroup) {
        Composite tablePanel = new Composite((Composite)tableGroup, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 165;
        layoutData.widthHint = 560;
        tablePanel.setLayoutData((Object)layoutData);
        this.tableViewer = new TableViewer(tablePanel, 68098);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.createTableColumns(tablePanel);
        this.createCellEditors(table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.specs);
        this.tableViewer.setComparer(new IElementComparer(){

            public boolean equals(Object a, Object b) {
                return a == b;
            }

            public int hashCode(Object element) {
                return element.hashCode();
            }
        });
    }

    private void createTableColumns(Composite tablePanel) {
        TableColumnLayout columnLayout = new TableColumnLayout();
        tablePanel.setLayout((Layout)columnLayout);
        this.createDummyColumn(columnLayout);
        if (this.pushSpecs) {
            this.createModeColumn(columnLayout);
        }
        this.createSrcColumn(columnLayout);
        this.createDstColumn(columnLayout);
        this.createForceColumn(columnLayout);
        this.createRemoveColumn(columnLayout);
    }

    private void createDummyColumn(TableColumnLayout columnLayout) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 16384);
        TableColumn column = viewerColumn.getColumn();
        columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(0, 0, false));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider());
    }

    private void createModeColumn(TableColumnLayout columnLayout) {
        TableViewerColumn column = this.createColumn(columnLayout, UIText.RefSpecPanel_columnMode, 23, 0x1000000);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return RefSpecPanel.isDeleteRefSpec(element) ? UIText.RefSpecPanel_modeDelete : UIText.RefSpecPanel_modeUpdate;
            }

            public Image getImage(Object element) {
                return RefSpecPanel.isDeleteRefSpec(element) ? RefSpecPanel.this.imageRegistry.get(RefSpecPanel.IMAGE_DELETE) : RefSpecPanel.this.imageRegistry.get(RefSpecPanel.IMAGE_ADD);
            }

            public String getToolTipText(Object element) {
                if (RefSpecPanel.isDeleteRefSpec(element)) {
                    return String.valueOf(UIText.RefSpecPanel_modeDeleteDescription) + '\n' + UIText.RefSpecPanel_clickToChange;
                }
                return String.valueOf(UIText.RefSpecPanel_modeUpdateDescription) + '\n' + UIText.RefSpecPanel_clickToChange;
            }
        });
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return RefSpecPanel.this.modeCellEditor;
            }

            protected Object getValue(Object element) {
                return RefSpecPanel.isDeleteRefSpec(element);
            }

            protected void setValue(Object element, Object value) {
                RefSpec oldSpec = (RefSpec)element;
                if (((Boolean)value).booleanValue()) {
                    RefSpec newSpec = RefSpecPanel.setRefSpecSource(oldSpec, null);
                    RefSpecPanel.this.setRefSpec(oldSpec, newSpec);
                } else {
                    final RefSpec newSpec = RefSpecPanel.setRefSpecSource(oldSpec, UIText.RefSpecPanel_refChooseSome);
                    RefSpecPanel.this.setRefSpec(oldSpec, newSpec);
                    RefSpecPanel.this.tableViewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RefSpecPanel.this.tableViewer.editElement((Object)newSpec, RefSpecPanel.this.srcColumnIndex);
                        }
                    });
                }
            }
        });
    }

    private void createSrcColumn(TableColumnLayout columnLayout) {
        TableViewerColumn column = this.createColumn(columnLayout, UIText.RefSpecPanel_columnSrc, 40, 16384);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((RefSpec)element).getSource();
            }

            public String getToolTipText(Object element) {
                if (RefSpecPanel.this.isInvalidSpec(element)) {
                    return RefSpecPanel.this.errorMessage;
                }
                if (RefSpecPanel.isDeleteRefSpec(element)) {
                    return UIText.RefSpecPanel_srcDeleteDescription;
                }
                if (RefSpecPanel.this.pushSpecs) {
                    return UIText.RefSpecPanel_srcPushDescription;
                }
                return UIText.RefSpecPanel_srcFetchDescription;
            }

            public Color getBackground(Object element) {
                if (RefSpecPanel.this.isInvalidSpec(element)) {
                    return RefSpecPanel.this.errorBackgroundColor;
                }
                return null;
            }

            public Color getToolTipForegroundColor(Object element) {
                if (RefSpecPanel.this.isInvalidSpec(element)) {
                    return RefSpecPanel.this.errorTextColor;
                }
                return null;
            }
        });
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected boolean canEdit(Object element) {
                return !RefSpecPanel.isDeleteRefSpec(element);
            }

            protected CellEditor getCellEditor(Object element) {
                return RefSpecPanel.this.pushSpecs ? RefSpecPanel.this.localRefCellEditor : RefSpecPanel.this.remoteRefCellEditor;
            }

            protected Object getValue(Object element) {
                return ((RefSpec)element).getSource();
            }

            protected void setValue(Object element, Object value) {
                if (value == null || ((String)value).length() == 0 || ObjectId.zeroId().name().equals(value)) {
                    return;
                }
                RefSpec oldSpec = (RefSpec)element;
                RefSpec newSpec = RefSpecPanel.setRefSpecSource(oldSpec, (String)value);
                RefSpecPanel.this.setRefSpec(oldSpec, newSpec);
            }
        });
        TableColumn[] columns = this.tableViewer.getTable().getColumns();
        this.srcColumnIndex = 0;
        while (this.srcColumnIndex < columns.length) {
            if (columns[this.srcColumnIndex] == column.getColumn()) break;
            ++this.srcColumnIndex;
        }
    }

    private void createDstColumn(TableColumnLayout columnLayout) {
        TableViewerColumn column = this.createColumn(columnLayout, UIText.RefSpecPanel_columnDst, 40, 16384);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((RefSpec)element).getDestination();
            }

            public String getToolTipText(Object element) {
                if (RefSpecPanel.this.isInvalidSpec(element)) {
                    return RefSpecPanel.this.errorMessage;
                }
                if (RefSpecPanel.isDeleteRefSpec(element)) {
                    return UIText.RefSpecPanel_dstDeletionDescription;
                }
                if (RefSpecPanel.this.pushSpecs) {
                    return UIText.RefSpecPanel_dstPushDescription;
                }
                return UIText.RefSpecPanel_dstFetchDescription;
            }

            public Color getBackground(Object element) {
                if (RefSpecPanel.this.isInvalidSpec(element)) {
                    return RefSpecPanel.this.errorBackgroundColor;
                }
                return null;
            }

            public Color getToolTipForegroundColor(Object element) {
                if (RefSpecPanel.this.isInvalidSpec(element)) {
                    return RefSpecPanel.this.errorTextColor;
                }
                return null;
            }
        });
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return RefSpecPanel.this.pushSpecs ? RefSpecPanel.this.remoteRefCellEditor : RefSpecPanel.this.localRefCellEditor;
            }

            protected Object getValue(Object element) {
                return ((RefSpec)element).getDestination();
            }

            protected void setValue(Object element, Object value) {
                if (value == null || ((String)value).length() == 0) {
                    return;
                }
                RefSpec oldSpec = (RefSpec)element;
                RefSpec newSpec = RefSpecPanel.setRefSpecDestination(oldSpec, (String)value);
                RefSpecPanel.this.setRefSpec(oldSpec, newSpec);
            }
        });
    }

    private void createForceColumn(TableColumnLayout columnLayout) {
        TableViewerColumn column = this.createColumn(columnLayout, UIText.RefSpecPanel_columnForce, 30, 0x1000000);
        column.setLabelProvider((CellLabelProvider)new CheckboxLabelProvider(this.tableViewer.getControl()){

            @Override
            protected boolean isChecked(Object element) {
                return ((RefSpec)element).isForceUpdate();
            }

            @Override
            protected boolean isEnabled(Object element) {
                return !RefSpecPanel.isDeleteRefSpec(element);
            }

            public String getToolTipText(Object element) {
                if (!this.isEnabled(element)) {
                    return UIText.RefSpecPanel_forceDeleteDescription;
                }
                if (this.isChecked(element)) {
                    return String.valueOf(UIText.RefSpecPanel_forceTrueDescription) + '\n' + UIText.RefSpecPanel_clickToChange;
                }
                return String.valueOf(UIText.RefSpecPanel_forceFalseDescription) + '\n' + UIText.RefSpecPanel_clickToChange;
            }
        });
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected boolean canEdit(Object element) {
                return !RefSpecPanel.isDeleteRefSpec(element);
            }

            protected CellEditor getCellEditor(Object element) {
                return RefSpecPanel.this.forceUpdateCellEditor;
            }

            protected Object getValue(Object element) {
                return ((RefSpec)element).isForceUpdate();
            }

            protected void setValue(Object element, Object value) {
                RefSpec oldSpec = (RefSpec)element;
                RefSpec newSpec = oldSpec.setForceUpdate(((Boolean)value).booleanValue());
                RefSpecPanel.this.setRefSpec(oldSpec, newSpec);
            }
        });
    }

    private void createRemoveColumn(TableColumnLayout columnLayout) {
        TableViewerColumn column = this.createColumn(columnLayout, UIText.RefSpecPanel_columnRemove, 20, 0x1000000);
        column.setLabelProvider((CellLabelProvider)new CenteredImageLabelProvider(){

            @Override
            public Image getImage(Object element) {
                return RefSpecPanel.this.imageRegistry.get(RefSpecPanel.IMAGE_TRASH);
            }

            public String getToolTipText(Object element) {
                return NLS.bind((String)UIText.RefSpecPanel_removeDescription, (Object)RefSpecPanel.this.typeString());
            }
        });
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.tableViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return RefSpecPanel.this.removeSpecCellEditor;
            }

            protected Object getValue(Object element) {
                return null;
            }

            protected void setValue(Object element, Object value) {
                RefSpecPanel.this.removeRefSpec((RefSpec)element);
            }
        });
    }

    private TableViewerColumn createColumn(TableColumnLayout columnLayout, String text, int weight, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(text);
        columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight));
        return viewerColumn;
    }

    private void createCellEditors(Table table) {
        if (this.pushSpecs) {
            this.modeCellEditor = new CheckboxCellEditor((Composite)table);
        }
        this.localRefCellEditor = this.createLocalRefCellEditor(table);
        this.remoteRefCellEditor = this.createRemoteRefCellEditor(table);
        this.forceUpdateCellEditor = new CheckboxCellEditor((Composite)table);
        this.removeSpecCellEditor = new ClickableCellEditor(table);
    }

    private CellEditor createLocalRefCellEditor(Table table) {
        return this.createRefCellEditor(table, this.getRefsProposalProvider(true));
    }

    private CellEditor createRemoteRefCellEditor(Table table) {
        return this.createRefCellEditor(table, this.getRefsProposalProvider(false));
    }

    private CellEditor createRefCellEditor(Table table, IContentProposalProvider proposalProvider) {
        TextCellEditor cellEditor = new TextCellEditor((Composite)table);
        Text text = (Text)cellEditor.getControl();
        ContentAssistCommandAdapter assist = new ContentAssistCommandAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), proposalProvider, null, null, true);
        assist.setProposalAcceptanceStyle(2);
        return cellEditor;
    }

    private void createSpecsButtonsPanel(Composite parent) {
        Composite specsPanel = new Composite(parent, 0);
        specsPanel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        RowLayout layout = new RowLayout();
        layout.spacing = 10;
        specsPanel.setLayout((Layout)layout);
        this.forceUpdateAllButton = new Button(specsPanel, 8);
        this.forceUpdateAllButton.setText(UIText.RefSpecPanel_forceAll);
        this.forceUpdateAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList specsCopy = new ArrayList(RefSpecPanel.this.specs);
                for (RefSpec spec : specsCopy) {
                    if (RefSpecPanel.isDeleteRefSpec(spec)) continue;
                    RefSpecPanel.this.setRefSpec(spec, spec.setForceUpdate(true));
                }
            }
        });
        this.forceUpdateAllButton.setToolTipText(UIText.RefSpecPanel_forceAllDescription);
        this.updateForceUpdateAllButton();
        this.removeAllSpecButton = new Button(specsPanel, 8);
        this.removeAllSpecButton.setImage(this.imageRegistry.get(IMAGE_CLEAR));
        this.removeAllSpecButton.setText(UIText.RefSpecPanel_removeAll);
        this.removeAllSpecButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefSpecPanel.this.clearRefSpecs();
            }
        });
        this.removeAllSpecButton.setToolTipText(UIText.RefSpecPanel_removeAllDescription);
        this.updateRemoveAllSpecButton();
        this.addRefSpecTableListener(new SelectionChangeListener(){

            @Override
            public void selectionChanged() {
                RefSpecPanel.this.updateForceUpdateAllButton();
                RefSpecPanel.this.updateRemoveAllSpecButton();
            }
        });
    }

    private void tryAutoCompleteSrcToDst() {
        String src = this.creationSrcComboSupport.getContent();
        String dst = this.creationDstComboSupport.getContent();
        if (src == null || src.length() == 0) {
            return;
        }
        if (dst != null && dst.length() > 0) {
            String newDst = RefSpec.isWildcard((String)src) ? RefSpecPanel.wildcardSpecComponent(dst) : RefSpecPanel.unwildcardSpecComponent(dst, src);
            if (!dst.equals(newDst)) {
                this.creationDstCombo.setText(newDst);
            }
            return;
        }
        if (!RefSpecPanel.isValidRefExpression(src)) {
            return;
        }
        if (this.pushSpecs) {
            String newDst = src;
            newDst = this.deletePrefixes(src, "refs/tags/".substring("refs/".length()), "refs/heads/".substring("refs/".length()));
            this.creationDstCombo.setText(newDst);
        } else {
            for (RefSpec spec : this.predefinedConfigured) {
                if (!spec.matchSource(src)) continue;
                String newDst = spec.expandFromSource(src).getDestination();
                this.creationDstCombo.setText(newDst);
                return;
            }
            if (this.remoteConfig != null && src.startsWith("refs/heads/")) {
                String newDst = "refs/remotes/" + this.remoteConfig.getName() + '/' + src.substring("refs/heads/".length());
                this.creationDstCombo.setText(newDst);
            }
        }
    }

    private String deletePrefixes(String ref, String ... prefixes) {
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (ref.startsWith(prefix)) {
                return ref.substring(prefix.length());
            }
            ++n2;
        }
        return ref;
    }

    private void tryAutoCompleteDstToSrc() {
        String src = this.creationSrcComboSupport.getContent();
        String dst = this.creationDstComboSupport.getContent();
        if (dst == null || dst.length() == 0) {
            return;
        }
        if (src != null && src.length() > 0) {
            String newSrc = RefSpec.isWildcard((String)dst) ? RefSpecPanel.wildcardSpecComponent(src) : RefSpecPanel.unwildcardSpecComponent(src, dst);
            if (!src.equals(newSrc)) {
                this.creationSrcCombo.setText(newSrc);
            }
            return;
        }
    }

    private void validateCreationPanel() {
        String src = this.creationSrcComboSupport.getContent();
        String dst = this.creationDstComboSupport.getContent();
        boolean srcOk = false;
        boolean srcWildcard = RefSpec.isWildcard((String)src);
        if (src == null || src.length() == 0) {
            RefSpecPanel.setControlDecoration(this.creationSrcDecoration, "DEC_REQUIRED", UIText.RefSpecPanel_validationSrcUpdateRequired);
        } else if (this.pushSpecs) {
            if (!srcWildcard && !this.isLocalRef(src)) {
                RefSpecPanel.setControlDecoration(this.creationSrcDecoration, "DEC_ERROR", NLS.bind((String)UIText.RefSpecPanel_validationRefInvalidLocal, (Object)src));
            } else if (srcWildcard && !RefSpecPanel.isValidRefExpression(src)) {
                RefSpecPanel.setControlDecoration(this.creationSrcDecoration, "DEC_ERROR", NLS.bind((String)UIText.RefSpecPanel_validationRefInvalidExpression, (Object)src));
            } else {
                srcOk = true;
                if (srcWildcard && !this.isMatchingAny(src, this.localRefNames)) {
                    RefSpecPanel.setControlDecoration(this.creationSrcDecoration, "DEC_WARNING", NLS.bind((String)UIText.RefSpecPanel_validationRefNonMatchingLocal, (Object)src));
                } else {
                    this.creationSrcDecoration.hide();
                }
            }
        } else if (!srcWildcard && !this.isRemoteRef(src)) {
            RefSpecPanel.setControlDecoration(this.creationSrcDecoration, "DEC_ERROR", NLS.bind((String)UIText.RefSpecPanel_validationRefNonExistingRemote, (Object)src));
        } else if (srcWildcard && !this.isMatchingAny(src, this.remoteRefNames)) {
            RefSpecPanel.setControlDecoration(this.creationSrcDecoration, "DEC_WARNING", NLS.bind((String)UIText.RefSpecPanel_validationRefNonMatchingRemote, (Object)src));
            srcOk = true;
        } else {
            srcOk = true;
            this.creationSrcDecoration.hide();
        }
        boolean dstOk = false;
        if (dst == null || dst.length() == 0) {
            RefSpecPanel.setControlDecoration(this.creationDstDecoration, "DEC_REQUIRED", UIText.RefSpecPanel_validationDstRequired);
        } else if (!RefSpecPanel.isValidRefExpression(dst)) {
            RefSpecPanel.setControlDecoration(this.creationDstDecoration, "DEC_ERROR", NLS.bind((String)UIText.RefSpecPanel_validationDstInvalidExpression, (Object)dst));
        } else {
            this.creationDstDecoration.hide();
            dstOk = true;
        }
        boolean wildcardOk = true;
        if (srcOk && dstOk && srcWildcard ^ RefSpec.isWildcard((String)dst)) {
            RefSpecPanel.setControlDecoration(this.creationSrcDecoration, "DEC_ERROR", UIText.RefSpecPanel_validationWildcardInconsistent);
            RefSpecPanel.setControlDecoration(this.creationDstDecoration, "DEC_ERROR", UIText.RefSpecPanel_validationWildcardInconsistent);
            wildcardOk = false;
        }
        this.creationButton.setEnabled(srcOk && dstOk && wildcardOk);
    }

    private void validateDeleteCreationPanel() {
        String ref = this.deleteRefComboSupport.getContent();
        this.deleteButton.setEnabled(false);
        if (ref == null || ref.length() == 0) {
            RefSpecPanel.setControlDecoration(this.deleteRefDecoration, "DEC_REQUIRED", UIText.RefSpecPanel_validationRefDeleteRequired);
        } else if (!RefSpecPanel.isValidRefExpression(ref)) {
            RefSpecPanel.setControlDecoration(this.deleteRefDecoration, "DEC_ERROR", NLS.bind((String)UIText.RefSpecPanel_validationRefInvalidExpression, (Object)ref));
        } else if (RefSpec.isWildcard((String)ref)) {
            RefSpecPanel.setControlDecoration(this.deleteRefDecoration, "DEC_ERROR", UIText.RefSpecPanel_validationRefDeleteWildcard);
        } else if (!this.isRemoteRef(ref)) {
            RefSpecPanel.setControlDecoration(this.deleteRefDecoration, "DEC_ERROR", NLS.bind((String)UIText.RefSpecPanel_validationRefNonExistingRemoteDelete, (Object)ref));
        } else {
            this.deleteRefDecoration.hide();
            this.deleteButton.setEnabled(true);
        }
    }

    private void validateSpecs() {
        RefSpec oldInvalidSpec = this.invalidSpec;
        RefSpec oldInvalidSpecSameDst = this.invalidSpecSameDst;
        this.errorMessage = null;
        this.invalidSpec = null;
        this.invalidSpecSameDst = null;
        for (RefSpec spec : this.specs) {
            this.errorMessage = this.validateSpec(spec);
            if (this.errorMessage == null) continue;
            this.invalidSpec = spec;
            break;
        }
        if (this.errorMessage == null) {
            this.validateSpecsCrossDst();
        }
        if (this.invalidSpec != oldInvalidSpec || this.invalidSpecSameDst != oldInvalidSpecSameDst) {
            this.tableViewer.refresh();
        }
    }

    private String validateSpec(RefSpec spec) {
        String src = spec.getSource();
        String dst = spec.getDestination();
        boolean wildcard = spec.isWildcard();
        if (this.pushSpecs) {
            if (!RefSpecPanel.isDeleteRefSpec(spec)) {
                if (src.length() == 0) {
                    return UIText.RefSpecPanel_validationSrcUpdateRequired;
                }
                if (!wildcard && !this.isLocalRef(src)) {
                    return NLS.bind((String)UIText.RefSpecPanel_validationRefInvalidLocal, (Object)src);
                }
                if (wildcard && !RefSpecPanel.isValidRefExpression(src)) {
                    return NLS.bind((String)UIText.RefSpecPanel_validationRefInvalidExpression, (Object)src);
                }
            }
        } else {
            if (src == null || src.length() == 0) {
                return UIText.RefSpecPanel_validationSrcUpdateRequired;
            }
            if (!wildcard && !this.isRemoteRef(src)) {
                return NLS.bind((String)UIText.RefSpecPanel_validationRefNonExistingRemote, (Object)src);
            }
        }
        if (dst == null || dst.length() == 0) {
            if (RefSpecPanel.isDeleteRefSpec(spec)) {
                return UIText.RefSpecPanel_validationRefDeleteRequired;
            }
            return UIText.RefSpecPanel_validationDstRequired;
        }
        if (!RefSpecPanel.isValidRefExpression(dst)) {
            return NLS.bind((String)UIText.RefSpecPanel_validationRefInvalidExpression, (Object)dst);
        }
        if (RefSpecPanel.isDeleteRefSpec(spec) && !this.isRemoteRef(dst)) {
            return NLS.bind((String)UIText.RefSpecPanel_validationRefNonExistingRemoteDelete, (Object)dst);
        }
        return null;
    }

    private boolean isInvalidSpec(Object element) {
        return element == this.invalidSpec || element == this.invalidSpecSameDst;
    }

    /*
     * Exception decompiling
     */
    private void validateSpecsCrossDst() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean tryAddDestination(Map<String, RefSpec> dstsSpecsMap, String dst, RefSpec spec) {
        RefSpec other = dstsSpecsMap.put(dst, spec);
        if (other != null) {
            this.errorMessage = NLS.bind((String)UIText.RefSpecPanel_validationSpecificationsOverlappingDestination, (Object)dst);
            this.invalidSpec = other;
            this.invalidSpecSameDst = spec;
            return false;
        }
        return true;
    }

    private void updateAddPredefinedButton(Button button, List<RefSpec> predefined) {
        boolean enable = false;
        if (predefined != null) {
            for (RefSpec pre : predefined) {
                if (this.specs.contains(pre)) continue;
                enable = true;
                break;
            }
        }
        button.setEnabled(enable);
    }

    private void updateAddPredefinedButton(Button button, RefSpec predefined) {
        button.setEnabled(!this.specs.contains(predefined));
    }

    private void updateForceUpdateAllButton() {
        boolean enable = false;
        for (RefSpec spec : this.specs) {
            if (RefSpecPanel.isDeleteRefSpec(spec) || spec.isForceUpdate()) continue;
            enable = true;
            break;
        }
        this.forceUpdateAllButton.setEnabled(enable);
    }

    private void updateRemoveAllSpecButton() {
        this.removeAllSpecButton.setEnabled(!this.specs.isEmpty());
    }

    private String typeString() {
        return this.pushSpecs ? UIText.RefSpecPanel_push : UIText.RefSpecPanel_fetch;
    }

    private String typeStringTitle() {
        return this.pushSpecs ? UIText.RefSpecPanel_pushTitle : UIText.RefSpecPanel_fetchTitle;
    }

    private void addPredefinedRefSpecs(RefSpec predefined) {
        this.addPredefinedRefSpecs(Collections.singletonList(predefined));
    }

    private void addPredefinedRefSpecs(List<RefSpec> predefined) {
        for (RefSpec pre : predefined) {
            if (this.specs.contains(pre)) continue;
            this.addRefSpec(pre);
        }
    }

    private List<RefContentProposal> createContentProposals(Collection<Ref> refs, Ref HEAD) {
        TreeSet<Ref> set = new TreeSet<Ref>(new Comparator<Ref>(){

            @Override
            public int compare(Ref o1, Ref o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        set.addAll(refs);
        if (HEAD != null) {
            set.add(HEAD);
        }
        ArrayList<RefContentProposal> result = new ArrayList<RefContentProposal>(set.size());
        for (Ref r : set) {
            result.add(new RefContentProposal(this.localDb, r));
        }
        return result;
    }

    private List<RefContentProposal> createProposalsFilteredLocal(List<RefContentProposal> proposals) {
        ArrayList<RefContentProposal> result = new ArrayList<RefContentProposal>();
        for (RefContentProposal p : proposals) {
            String content = p.getContent();
            if (this.pushSpecs) {
                if (!content.equals("HEAD") && !content.startsWith("refs/heads/")) continue;
                result.add(p);
                continue;
            }
            if (!content.startsWith("refs/remotes/")) continue;
            result.add(p);
        }
        return result;
    }

    private boolean isRemoteRef(String ref) {
        return this.remoteRefNames.contains(ref);
    }

    private boolean isLocalRef(String ref) {
        return this.tryResolveLocalRef(ref) != null;
    }

    private boolean isMatchingAny(String ref, Collection<String> names) {
        String prefix = ref.substring(0, ref.length() - 1);
        for (String name : names) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private ObjectId tryResolveLocalRef(String ref) {
        if (!RefSpecPanel.isValidRefExpression(ref)) {
            return null;
        }
        try {
            return this.localDb.resolve(ref);
        }
        catch (IOException e) {
            Activator.logError("I/O error occurred during resolving expression: " + ref, e);
            return null;
        }
    }

    private class RefContentProposalProvider
    implements IContentProposalProvider {
        private List<RefContentProposal> proposals = Collections.emptyList();
        private final boolean tryResolvingLocally;

        private RefContentProposalProvider(boolean tryResolvingLocally) {
            this.tryResolvingLocally = tryResolvingLocally;
        }

        private void setProposals(List<RefContentProposal> proposals) {
            this.proposals = proposals;
        }

        public IContentProposal[] getProposals(String contents, int position) {
            ArrayList<RefContentProposal> result = new ArrayList<RefContentProposal>();
            if (contents.indexOf(42) != -1 || contents.indexOf(63) != -1) {
                if (RefSpecPanel.isValidRefExpression(contents)) {
                    result.add(new RefContentProposal(RefSpecPanel.this.localDb, contents, null));
                }
                String regex = ".*" + contents.replace("*", ".*").replace("?", ".?") + ".*";
                Pattern p = Pattern.compile(regex);
                for (RefContentProposal prop : this.proposals) {
                    if (!p.matcher(prop.getContent()).matches()) continue;
                    result.add(prop);
                }
            } else {
                ObjectId id;
                for (RefContentProposal prop : this.proposals) {
                    if (!prop.getContent().contains(contents)) continue;
                    result.add(prop);
                }
                if (this.tryResolvingLocally && result.isEmpty() && (id = RefSpecPanel.this.tryResolveLocalRef(contents)) != null) {
                    result.add(new RefContentProposal(RefSpecPanel.this.localDb, contents, id));
                }
            }
            return result.toArray(new IContentProposal[0]);
        }
    }
}

