/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.viewer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.VirtualSourceViewer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class DisassemblyPane
implements IPropertyChangeListener {
    private static final int VERTICAL_RULER_WIDTH = 12;
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    private Composite fControl;
    private VirtualSourceViewer fViewer;
    private IVerticalRuler fVerticalRuler;
    private IOverviewRuler fOverviewRuler;
    private SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    private IAnnotationAccess fAnnotationAccess;
    private MarkerAnnotationPreferences fAnnotationPreferences;
    private String fViewContextMenuId;
    private String fRulerContextMenuId;
    private MenuManager fTextMenuManager;
    private MenuManager fRulerMenuManager;
    private Menu fRulerContextMenu;
    private Menu fTextContextMenu;
    private IMenuListener fMenuListener;
    private MouseListener fMouseListener;
    private Map<String, IAction> fActions = new HashMap<String, IAction>(10);

    public DisassemblyPane(String contextMenuId, String rulerMenuId) {
        this.fAnnotationPreferences = new MarkerAnnotationPreferences();
        this.setViewContextMenuId(contextMenuId);
        this.setRulerContextMenuId(rulerMenuId);
    }

    public void create(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        this.fVerticalRuler = this.createCompositeRuler();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        this.createActions();
        this.fViewer = this.createViewer(composite, this.fVerticalRuler, this.fOverviewRuler);
        this.fControl = composite;
        this.createViewContextMenu();
        this.createRulerContextMenu();
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.install(this.getEditorPreferenceStore());
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    public VirtualSourceViewer getViewer() {
        return this.fViewer;
    }

    public void dispose() {
        this.getEditorPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        if (this.fSourceViewerDecorationSupport != null) {
            this.fSourceViewerDecorationSupport.dispose();
            this.fSourceViewerDecorationSupport = null;
        }
        if (this.fActions != null) {
            this.fActions.clear();
            this.fActions = null;
        }
    }

    protected void createActions() {
    }

    public void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            this.fActions.remove(actionID);
        } else {
            this.fActions.put(actionID, action);
        }
    }

    public IAction getAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        return this.fActions.get(actionID);
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator("additions"));
        this.addAction(menu, IInternalCDebugUIConstants.ACTION_TOGGLE_BREAKPOINT);
        this.addAction(menu, IInternalCDebugUIConstants.ACTION_ENABLE_DISABLE_BREAKPOINT);
        this.addAction(menu, IInternalCDebugUIConstants.ACTION_BREAKPOINT_PROPERTIES);
    }

    protected void viewContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void addAction(IMenuManager menu, String group, String actionId) {
        IAction action = this.getAction(actionId);
        if (action != null) {
            IMenuManager subMenu;
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if ((subMenu = menu.findMenuUsingPath(group)) != null) {
                subMenu.add(action);
            } else {
                menu.appendToGroup(group, action);
            }
        }
    }

    protected void addAction(IMenuManager menu, String actionId) {
        IAction action = this.getAction(actionId);
        if (action != null) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            menu.add(action);
        }
    }

    protected final IMenuListener getContextMenuListener() {
        if (this.fMenuListener == null) {
            this.fMenuListener = new IMenuListener(){

                public void menuAboutToShow(IMenuManager menu) {
                    String id = menu.getId();
                    if (DisassemblyPane.this.getRulerContextMenuId().equals(id)) {
                        DisassemblyPane.this.rulerContextMenuAboutToShow(menu);
                    } else if (DisassemblyPane.this.getViewContextMenuId().equals(id)) {
                        DisassemblyPane.this.viewContextMenuAboutToShow(menu);
                    }
                }
            };
        }
        return this.fMenuListener;
    }

    protected final MouseListener getRulerMouseListener() {
        if (this.fMouseListener == null) {
            this.fMouseListener = new MouseListener(){
                private boolean fDoubleClicked = false;

                private void triggerAction(String actionID) {
                    IAction action = DisassemblyPane.this.getAction(actionID);
                    if (action != null) {
                        if (action instanceof IUpdate) {
                            ((IUpdate)action).update();
                        }
                        if (action.isEnabled()) {
                            action.run();
                        }
                    }
                }

                public void mouseUp(MouseEvent e) {
                    if (1 == e.button && !this.fDoubleClicked) {
                        this.triggerAction("RulerClick");
                    }
                    this.fDoubleClicked = false;
                }

                public void mouseDoubleClick(MouseEvent e) {
                    if (1 == e.button) {
                        this.fDoubleClicked = true;
                        this.triggerAction(IInternalCDebugUIConstants.ACTION_TOGGLE_BREAKPOINT);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    StyledText text = DisassemblyPane.this.getViewer().getTextWidget();
                    if (text != null && !text.isDisposed()) {
                        Display display = text.getDisplay();
                        Point location = display.getCursorLocation();
                        DisassemblyPane.this.getRulerContextMenu().setLocation(location.x, location.y);
                    }
                }
            };
        }
        return this.fMouseListener;
    }

    private Menu getTextContextMenu() {
        return this.fTextContextMenu;
    }

    private void setTextContextMenu(Menu textContextMenu) {
        this.fTextContextMenu = textContextMenu;
    }

    protected Menu getRulerContextMenu() {
        return this.fRulerContextMenu;
    }

    private void setRulerContextMenu(Menu rulerContextMenu) {
        this.fRulerContextMenu = rulerContextMenu;
    }

    public String getRulerContextMenuId() {
        return this.fRulerContextMenuId;
    }

    private void setRulerContextMenuId(String rulerContextMenuId) {
        Assert.isNotNull((Object)rulerContextMenuId);
        this.fRulerContextMenuId = rulerContextMenuId;
    }

    public String getViewContextMenuId() {
        return this.fViewContextMenuId;
    }

    private void setViewContextMenuId(String viewContextMenuId) {
        Assert.isNotNull((Object)viewContextMenuId);
        this.fViewContextMenuId = viewContextMenuId;
    }

    private void createViewContextMenu() {
        String id = this.getViewContextMenuId();
        this.fTextMenuManager = new MenuManager(id, id);
        this.fTextMenuManager.setRemoveAllWhenShown(true);
        this.fTextMenuManager.addMenuListener(this.getContextMenuListener());
        StyledText styledText = this.getViewer().getTextWidget();
        this.setTextContextMenu(this.fTextMenuManager.createContextMenu((Control)styledText));
        styledText.setMenu(this.getTextContextMenu());
    }

    private void createRulerContextMenu() {
        String id = this.getRulerContextMenuId();
        this.fRulerMenuManager = new MenuManager(id, id);
        this.fRulerMenuManager.setRemoveAllWhenShown(true);
        this.fRulerMenuManager.addMenuListener(this.getContextMenuListener());
        Control rulerControl = this.fVerticalRuler.getControl();
        this.setRulerContextMenu(this.fRulerMenuManager.createContextMenu(rulerControl));
        rulerControl.setMenu(this.getRulerContextMenu());
        rulerControl.addMouseListener(this.getRulerMouseListener());
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    protected VirtualSourceViewer createViewer(Composite parent, IVerticalRuler vertRuler, IOverviewRuler ovRuler) {
        int styles = 68354;
        VirtualSourceViewer viewer = new VirtualSourceViewer(parent, this.fVerticalRuler, this.fOverviewRuler, true, styles);
        viewer.getControl().setLayoutData(parent.getLayoutData());
        viewer.setEditable(false);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)IInternalCDebugUIConstants.DISASSEMBLY_FONT));
        viewer.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        viewer.configure(new SourceViewerConfiguration());
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        this.getEditorPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        return viewer;
    }

    private IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess();
    }

    private void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        for (Object pref : this.fAnnotationPreferences.getAnnotationPreferences()) {
            support.setAnnotationPreference((AnnotationPreference)pref);
        }
        support.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
    }

    private IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    private ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }

    protected IVerticalRuler createCompositeRuler() {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(12, this.getAnnotationAccess()));
        Iterator iter = ruler.getDecoratorIterator();
        while (iter.hasNext()) {
            IVerticalRulerColumn col = (IVerticalRulerColumn)iter.next();
            if (!(col instanceof AnnotationRulerColumn)) continue;
            AnnotationRulerColumn column = (AnnotationRulerColumn)col;
            for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
                column.addAnnotationType(preference.getAnnotationType());
            }
            column.addAnnotationType((Object)"org.eclipse.text.annotation.unknown");
            break;
        }
        return ruler;
    }

    private IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        OverviewRuler ruler = new OverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
        for (Object o : this.fAnnotationPreferences.getAnnotationPreferences()) {
            AnnotationPreference preference = (AnnotationPreference)o;
            if (!preference.contributesToHeader()) continue;
            ruler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        return ruler;
    }

    private IOverviewRuler getOverviewRuler() {
        if (this.fOverviewRuler == null) {
            this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        }
        return this.fOverviewRuler;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    private IPreferenceStore getEditorPreferenceStore() {
        return EditorsUI.getPreferenceStore();
    }

    public MenuManager getTextMenuManager() {
        return this.fTextMenuManager;
    }

    public MenuManager getRulerMenuManager() {
        return this.fRulerMenuManager;
    }

    public IVerticalRuler getVerticalRuler() {
        return this.fVerticalRuler;
    }
}

