/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeInstallableUnitItem;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.epp.mpc.core.model.IIu;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.ui.Operation;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceNodeCatalogItem
extends CatalogItem {
    private static final Field changeSupportField;
    private URL marketplaceUrl;
    private Boolean userFavorite;
    private List<MarketplaceNodeInstallableUnitItem> installableUnitItems = new ArrayList<MarketplaceNodeInstallableUnitItem>();
    private transient PropertyChangeSupport propertyChangeSupport;

    static {
        Field field;
        block8: {
            Boolean accessible = null;
            field = null;
            try {
                try {
                    field = CatalogItem.class.getDeclaredField("changeSupport");
                    accessible = field.isAccessible();
                    field.setAccessible(true);
                }
                catch (Exception e) {
                    field = null;
                    MarketplaceClientCore.error((String)Messages.MarketplaceNodeCatalogItem_changeSupportError, (Throwable)e);
                    if (field != null && accessible != null && !accessible.equals(field.isAccessible())) {
                        field.setAccessible(accessible);
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (field != null && accessible != null && !accessible.equals(field.isAccessible())) {
                    field.setAccessible(accessible);
                }
                throw throwable;
            }
            if (field != null && accessible != null && !accessible.equals(field.isAccessible())) {
                field.setAccessible(accessible);
            }
        }
        changeSupportField = field;
    }

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = this.accessPropertyChangeSupport();
        }
        return this.propertyChangeSupport;
    }

    private synchronized PropertyChangeSupport accessPropertyChangeSupport() {
        Boolean accessible = null;
        try {
            PropertyChangeSupport changeSupport;
            accessible = changeSupportField.isAccessible();
            changeSupportField.setAccessible(true);
            PropertyChangeSupport propertyChangeSupport = changeSupport = (PropertyChangeSupport)changeSupportField.get((Object)this);
            return propertyChangeSupport;
        }
        catch (Exception e) {
            MarketplaceClientCore.error((String)Messages.MarketplaceNodeCatalogItem_changeSupportAccessError, (Throwable)e);
        }
        finally {
            if (changeSupportField != null && accessible != null && !accessible.equals(changeSupportField.isAccessible())) {
                changeSupportField.setAccessible(accessible);
            }
        }
        return null;
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        PropertyChangeSupport propertyChangeSupport = this.getPropertyChangeSupport();
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(property, oldValue, newValue);
        }
    }

    public void setInstallableUnits(List<String> installableUnits) {
        super.setInstallableUnits(installableUnits);
        this.updateInstallableUnitItems();
    }

    private void updateInstallableUnitItems() {
        List iuElements = this.getData().getIus().getIuElements();
        ArrayList<MarketplaceNodeInstallableUnitItem> installableUnitItems = new ArrayList<MarketplaceNodeInstallableUnitItem>();
        for (String iuId : this.installableUnits) {
            MarketplaceNodeInstallableUnitItem iuItem = this.getInstallableUnitItem(iuId);
            if (iuItem == null) {
                iuItem = new MarketplaceNodeInstallableUnitItem();
                iuItem.setId(iuId);
            }
            for (IIu iu : iuElements) {
                if (!iu.getId().equals(iuId)) continue;
                iuItem.init(iu);
                break;
            }
            installableUnitItems.add(iuItem);
        }
        this.doSetInstallableUnitItems(installableUnitItems);
    }

    public MarketplaceNodeInstallableUnitItem getInstallableUnitItem(String iuId) {
        if (this.installableUnitItems == null) {
            return null;
        }
        for (MarketplaceNodeInstallableUnitItem iuItem : this.installableUnitItems) {
            if (!iuId.equals(iuItem.getId())) continue;
            return iuItem;
        }
        return null;
    }

    public void setInstallableUnitItems(List<MarketplaceNodeInstallableUnitItem> installableUnitItems) {
        this.doSetInstallableUnitItems(new ArrayList<MarketplaceNodeInstallableUnitItem>(installableUnitItems));
        this.updateInstallableUnits();
    }

    private void doSetInstallableUnitItems(List<MarketplaceNodeInstallableUnitItem> items) {
        this.installableUnitItems = Collections.unmodifiableList(items);
    }

    private void updateInstallableUnits() {
        this.installableUnits.clear();
        for (MarketplaceNodeInstallableUnitItem iuItem : this.installableUnitItems) {
            this.installableUnits.add(iuItem.getId());
        }
        super.setInstallableUnits(this.installableUnits);
    }

    public List<MarketplaceNodeInstallableUnitItem> getInstallableUnitItems() {
        return this.installableUnitItems;
    }

    public INode getData() {
        return (INode)super.getData();
    }

    public URL getMarketplaceUrl() {
        return this.marketplaceUrl;
    }

    public void setMarketplaceUrl(URL marketplaceUrl) {
        this.marketplaceUrl = marketplaceUrl;
    }

    public Boolean getUpdateAvailable() {
        Boolean updateAvailable = false;
        List<MarketplaceNodeInstallableUnitItem> installableUnitItems = this.getInstallableUnitItems();
        for (MarketplaceNodeInstallableUnitItem iuItem : installableUnitItems) {
            Boolean iuUpdateAvailable = iuItem.getUpdateAvailable();
            if (iuUpdateAvailable == null) {
                updateAvailable = null;
                continue;
            }
            if (!Boolean.TRUE.equals(iuUpdateAvailable)) continue;
            return true;
        }
        return updateAvailable;
    }

    public Boolean getHasOptionalFeatures() {
        Boolean hasOptional = false;
        List<MarketplaceNodeInstallableUnitItem> installableUnitItems = this.getInstallableUnitItems();
        for (MarketplaceNodeInstallableUnitItem iuItem : installableUnitItems) {
            Boolean iuOptional = iuItem.getOptional();
            if (iuOptional == null) {
                hasOptional = null;
                continue;
            }
            if (!Boolean.TRUE.equals(iuOptional)) continue;
            return true;
        }
        return hasOptional;
    }

    public Boolean getAvailable() {
        Boolean available = super.getAvailable();
        if (available == null) {
            Boolean iuAvailable;
            List<MarketplaceNodeInstallableUnitItem> installableUnitItems = this.getInstallableUnitItems();
            if (installableUnitItems == null || installableUnitItems.isEmpty()) {
                return false;
            }
            available = true;
            boolean hasRequired = false;
            for (MarketplaceNodeInstallableUnitItem iuItem : installableUnitItems) {
                if (iuItem.isOptional()) continue;
                hasRequired = true;
                iuAvailable = iuItem.getAvailable();
                if (Boolean.FALSE.equals(iuAvailable)) {
                    return false;
                }
                if (iuAvailable != null) continue;
                available = null;
            }
            if (!hasRequired) {
                for (MarketplaceNodeInstallableUnitItem iuItem : installableUnitItems) {
                    iuAvailable = iuItem.getAvailable();
                    if (Boolean.FALSE.equals(iuAvailable)) {
                        return false;
                    }
                    if (iuAvailable != null) continue;
                    available = null;
                }
            }
        }
        return available;
    }

    public List<Operation> getAvailableOperations() {
        ArrayList<Operation> available = new ArrayList<Operation>();
        if (!this.getInstallableUnits().isEmpty()) {
            if (this.isInstalled()) {
                if (this.maybeUpdateAvailable()) {
                    available.add(Operation.UPDATE);
                }
                if (this.maybeHasOptionalFeatures()) {
                    available.add(Operation.CHANGE);
                }
                available.add(Operation.UNINSTALL);
            } else if (this.maybeAvailable()) {
                available.add(Operation.INSTALL);
            }
        }
        return available;
    }

    private boolean maybeAvailable() {
        Boolean available = this.getAvailable();
        return available == null || Boolean.TRUE.equals(available);
    }

    private boolean maybeUpdateAvailable() {
        Boolean updateAvailable = this.getUpdateAvailable();
        return updateAvailable == null || Boolean.TRUE.equals(updateAvailable);
    }

    private boolean maybeHasOptionalFeatures() {
        Boolean hasOptional = this.getHasOptionalFeatures();
        return !Boolean.FALSE.equals(hasOptional) && this.getInstallableUnitItems().size() > 1;
    }

    public void setUserFavorite(Boolean favorited) {
        if (favorited == null && this.userFavorite != null || favorited != null && !favorited.equals(this.userFavorite)) {
            Boolean oldValue = this.userFavorite;
            this.userFavorite = favorited;
            this.firePropertyChange("userFavorite", oldValue, favorited);
        }
    }

    public Boolean getUserFavorite() {
        return this.userFavorite;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MarketplaceNodeCatalogItem other = (MarketplaceNodeCatalogItem)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

