#include <stm32f4xx.h>
#include "ADC.h"

uint32_t filteredPotVal;

uint32_t ADC_pot_read(){
	while(!((ADC1->SR) & ADC_SR_EOC)){}
	return ADC1->DR;
}

void ADC_init(){
	//initialize the clock to the digital interface of the ADC
	RCC->APB2ENR |= RCC_APB2ENR_ADC1EN;
	//turn on the ADC
	ADC1->CR2 |= ADC_CR2_ADON;
	//select continuous conversion mode
	ADC1->CR2 |= ADC_CR2_CONT;
	//set the sampling time to 480 cycles (longer sampling time reduces noise and speed is not really required here)
	ADC1->SMPR2 = ADC_SMPR2_SMP0;

	//enable the clock to the analog pin
	RCC->AHB1ENR |= RCC_AHB1ENR_GPIOCEN;
	//set pin PC4 as analog
	GPIOC->MODER |= GPIO_MODER_MODER4;

	//select channel pin ADC12_14 (PC4) as analog input for ADC1 (set as only channel in a regular sequence)
	ADC1->SQR3 = 14;

	//start the conversions
	ADC1->CR2 |= ADC_CR2_SWSTART;
}

